#include "display.h"

/**************************************************************************************************************************
************************** Decompress images anf fonts from pictures.h and put them to the RAM memeory of FT800 ***********
**************************************************************************************************************************/
void Display::LoadImagesAndFonts()
{
    (*_TFT).WrCmd32(CMD_INFLATE);
    (*_TFT).WrCmd32(IMAGE_ADDR_HUMIDITY);
    (*_TFT).WrCmdBufFromFlash(hum_icon, sizeof(hum_icon));

    (*_TFT).WrCmd32(CMD_INFLATE);
    (*_TFT).WrCmd32(IMAGE_ADDR_TEMPERATURE);
    (*_TFT).WrCmdBufFromFlash(temp_icon, sizeof(temp_icon));   
       
    (*_TFT).WrCmd32(CMD_INFLATE);
    (*_TFT).WrCmd32(IMAGE_ADDR_SENSOR);
    (*_TFT).WrCmdBufFromFlash(HYT_photo, sizeof(HYT_photo));
}

/**************************************************************************************************************************
************************** Prepare images and fronts **********************************************************************
**************************************************************************************************************************/
void Display::HandleAllBitmaps()
{
     // start FT800 display list
    StartDL();
    
    (*_TFT).DL(BITMAP_HANDLE(0));
    (*_TFT).DL(BITMAP_SOURCE(IMAGE_ADDR_HUMIDITY));
    (*_TFT).DL(BITMAP_LAYOUT(ARGB4, 60, 38));
    (*_TFT).DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 30, 38));
    
    (*_TFT).DL(BITMAP_HANDLE(1));
    (*_TFT).DL(BITMAP_SOURCE(IMAGE_ADDR_TEMPERATURE));
    (*_TFT).DL(BITMAP_LAYOUT(ARGB4, 42, 42));
    (*_TFT).DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 21, 42));
        
    (*_TFT).DL(BITMAP_HANDLE(2));
    (*_TFT).DL(BITMAP_SOURCE(IMAGE_ADDR_SENSOR));
    (*_TFT).DL(BITMAP_LAYOUT(ARGB1555, 208, 176));
    (*_TFT).DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 104, 176));
    // finish FT800 display list
    FinishDL();
}