#include "mbed.h"

#ifndef STATISTICS_H_
#define STATISTICS_H_

#define  INIT_STATISTICS_NUMBER  32767
#define  DELTA_HUMIDITY  6
#define  DELTA_TEMPERATURE  1
#define  TEMPERATURE_MULTIPLIER  10

/**************************************************************************************************************************
************************** User class for calculate statistics for last 24 hrs ********************************************
**************************************************************************************************************************/

class Statistics
{
public:
    // xxxx24hrs[][] arrays contains all 24-hrs statistics data:
    // 1. xxxx24hrs[0][0...287] - Average values calculated for each five-minute interval
    // 2. xxxx24hrs[1][0...287] - Minimums calculated for each five-minute interval
    // 2. xxxx24hrs[2][0...287] - Maximums calculated for each five-minute interval
    // p.s. there are 288 five-minute intervals in 24 hours

    short int humidity24hrs[3][288];
    short int temperature24hrs[3][288];

    uint64_t UpdateStatistics(float humidity, float temperature, uint64_t seconds, uint64_t changeSecondsOffset);
    void InitValues(float humidity, float temperature);
    
private:
    
    // functions called every second to update average value, minimum and maximum in current five-minute interval
    void CalculateTemperature(float temperature, short int secondsIn5min);
    void CalculateHumididty(float humidity, short int secondsIn5min);
    // function called every 5 minutes to add new value to xxxx24hrs[][] arrays
    uint64_t Update24hrsData(uint64_t changeSecondsOffset);
    
    // counter of five-minute intervals (0...287)
    short int Counter24hrs;
    // values for calculations "inside" five-minute interval
    short int humidity5min[300], temperature5min[300];
    int humidity5minAverage, temperature5minAverage;
    int humidity5minSum, temperature5minSum;
    short int humidity5minMax, humidity5minMin, temperature5minMax, temperature5minMin;
};

#endif /* STATISTICS_H_ */