#include "display.h"

/* For drawing current values */

/**************************************************************************************************************************
************************** Draw horisontal grid for current temperature (-50 .. +125) *************************************
**************************************************************************************************************************/
void Display::HorisontalGrid_Current_Temperature()
{
    (*_TFT).DL(COLOR_RGB(20, 20, 20));
    char gridNumb = 125 + 50;
    for (int i = 70 * 16; i <= 225 * 16; i += 352) {
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(LINE_WIDTH(8));
        (*_TFT).DL(VERTEX2F(15 * 16, i));
        (*_TFT).DL(VERTEX2F(423 * 16, i));
        if (gridNumb  >= 50) {
            (*_TFT).Number(435, i/16 - 9, 26, 0, gridNumb - 50);
        } else if (gridNumb == 25) {
            (*_TFT).Text(435, i/16 - 9, 26, 0, "-25");
        } else if (gridNumb == 0) {
            (*_TFT).Text(435, i/16 - 9, 26, 0, "-50");
        }
        gridNumb = gridNumb - 25;
    }
}

/**************************************************************************************************************************
************************** Draw horisontal grid for current humidity (0 .. 100) *******************************************
**************************************************************************************************************************/
void Display::HorisontalGrid_Current_Humidity()
{
    (*_TFT).DL(COLOR_RGB(20, 20, 20));
    char gridNumb = 100;
    for (int i = 70 * 16; i <= 220 * 16; i += 600) {
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(LINE_WIDTH(8));
        (*_TFT).DL(VERTEX2F(15 * 16, i));
        (*_TFT).DL(VERTEX2F(423 * 16, i));
        (*_TFT).Number(435, i/16 - 9, 26, 0, gridNumb);
        gridNumb = gridNumb - 25;
    }
}



/* For drawing statistics values */

/**************************************************************************************************************************
************************** Draw horisontal grid for temperature (-50 .. +125) *********************************************
**************************************************************************************************************************/
void Display::HorisontalGrid_Statistics_Temperature()
{
    (*_TFT).DL(COLOR_RGB(80, 80, 80));
    char gridNumb = 125 + 50;
    for (int i = 100 * 16; i <= 200 * 16; i += 228) {
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(LINE_WIDTH(8));
        if (gridNumb == 0 + 50) {
            (*_TFT).DL(LINE_WIDTH(12));
        }
        (*_TFT).DL(VERTEX2F(25 * 16, i));
        (*_TFT).DL(VERTEX2F(438 * 16, i));
        if (gridNumb  >= 50) {
            (*_TFT).Number(445, i/16 - 9, 26, 0, gridNumb - 50);
        } else if (gridNumb == 25) {
            (*_TFT).Text(445, i/16 - 9, 26, 0, "-25");
        } else if (gridNumb == 0) {
            (*_TFT).Text(445, i/16 - 9, 26, 0, "-50");
        }
        gridNumb = gridNumb - 25;
    }
}

/**************************************************************************************************************************
************************** Draw horisontal grid for humidity (0 .. 100) ***************************************************
**************************************************************************************************************************/
void Display::HorisontalGrid_Statistics_Humidity()
{
    (*_TFT).DL(COLOR_RGB(80, 80, 80));
    char gridNumb = 100;
    for (int i = 100 * 16; i <= 200 * 16; i += (25*16)) {
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(LINE_WIDTH(8));
        (*_TFT).DL(VERTEX2F(25 * 16, i));
        (*_TFT).DL(VERTEX2F(438 * 16, i));
        (*_TFT).Number(445, i/16 - 9, 26, 0, gridNumb);
        gridNumb = gridNumb - 25;
    }
}

/**************************************************************************************************************************
************************** Draw vertical grid for 24-hour interval ******************************************&*************
**************************************************************************************************************************/
void Display::VerticalGrid24hrs(uint64_t gridSecondsOffset)
{
    uint64_t gridSeconds = gridSecondsOffset;
    for (int i = 25 * 16; i <= 433 * 16; i += 17 * 16) {
        (*_TFT).DL(COLOR_RGB(80, 80, 80));
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(LINE_WIDTH(8));
        (*_TFT).DL(VERTEX2F(i, 100 * 16));
        (*_TFT).DL(VERTEX2F(i, 200 * 16));
        CreateStringTime(gridTimeStr, gridSeconds);
        if ((i - 25 * 16) % (3 * 17 * 16) == 0) {
            (*_TFT).Text(i/16 - 20, 210, 20, 0, gridTimeStr);
            (*_TFT).DL(COLOR_RGB(20, 20, 20));
            (*_TFT).DL(BEGIN(LINES));
            (*_TFT).DL(VERTEX2F(i, 100 * 16));
            (*_TFT).DL(VERTEX2F(i, 205 * 16));
        }
        gridSeconds = gridSeconds + 3600;
    }
}

/**************************************************************************************************************************
************************** Draw vertical grid for three-hour interval *****************************************************
**************************************************************************************************************************/
void Display::VerticalGrid3hrs(uint64_t gridSecondsOffset)
{
    (*_TFT).DL(COLOR_RGB(0, 0, 0));
    uint64_t gridSeconds = 300 * timePoint3hrs + gridSecondsOffset;
    for (int i = 25 * 16; i <= 433 * 16; i += 34 * 16) {
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(LINE_WIDTH(8));
        (*_TFT).DL(VERTEX2F(i, 100 * 16));
        (*_TFT).DL(VERTEX2F(i, 200 * 16));
        CreateStringTime(gridTimeStr, gridSeconds);
        if ((i - 25*16) % (2 * 34 * 16) == 0) {
            (*_TFT).DL(COLOR_RGB(80, 80, 80));
            (*_TFT).Text(i/16 - 20, 210, 20, 0, gridTimeStr);
            (*_TFT).DL(COLOR_RGB(0, 0, 0));
            (*_TFT).DL(BEGIN(LINES));
            (*_TFT).DL(VERTEX2F(i, 100 * 16));
            (*_TFT).DL(VERTEX2F(i, 205 * 16));
        }
        gridSeconds = gridSeconds + 900;
    }
}

/**************************************************************************************************************************
************************** Draw vertical grid for 30-minutes interval *****************************************************
**************************************************************************************************************************/
void Display::VerticalGrid30min(uint64_t gridSecondsOffset)
{
    (*_TFT).DL(COLOR_RGB(0, 0, 0));
    uint64_t gridSeconds = 300 * (timePoint3hrs + timePoint30min) + gridSecondsOffset;
    for (int i = 25 * 16; i <= 433 * 16; i += 68 * 16) {
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(LINE_WIDTH(8));
        (*_TFT).DL(VERTEX2F(i, 100 * 16));
        (*_TFT).DL(VERTEX2F(i, 205 * 16));
        CreateStringTime(gridTimeStr, gridSeconds);
        (*_TFT).DL(COLOR_RGB(80, 80, 80));
        (*_TFT).Text(i/16 - 20, 210, 20, 0, gridTimeStr);
        (*_TFT).DL(COLOR_RGB(0, 0, 0));
        gridSeconds = gridSeconds + 300;
    }
}