#include "display.h"

/**************************************************************************************************************************
************************** Display text & image about the HYT sensor ******************************************************
**************************************************************************************************************************/
void Display::AboutSensor()
{
    // start FT800 display list
    StartDL();

    // Write text
    (*_TFT).DL(COLOR_RGB(0, 0, 0));
    (*_TFT).DL(BEGIN(LINES));
    (*_TFT).DL(LINE_WIDTH(8));
    (*_TFT).DL(VERTEX2II(14, 79, 0, 0));
    (*_TFT).DL(VERTEX2II(14, 220, 0, 0));
    (*_TFT).Text(24, 78, 27, 0, "Capacitive polymer humidity sensor with I2C interface");
    (*_TFT).DL(COLOR_RGB(9, 0, 63));
    (*_TFT).Text(24, 115, 26, 0, "Measuring range: 0 .. 100% rH,  -40 .. 125 C");
    (*_TFT).Text(24, 135, 26, 0, "Accuracy: +/-1.8% rH (0 .. 80% rH),");
    (*_TFT).Text(88, 155, 26, 0, "+/-0.2 C (0 .. 60 C)");
    (*_TFT).Text(24, 175, 26, 0, "Response time: < 4 sec");
    (*_TFT).Text(24, 195, 26, 0, "Operating voltage: 2.7 to 5.5 V");
    (*_TFT).DL(COLOR_RGB(0, 0, 0));
    (*_TFT).Text(11, 15, 30, 0, "HYT-271 sensor from IST");

    // Show photo
    (*_TFT).DL(COLOR_RGB(255, 255, 255));
    (*_TFT).DL(BEGIN(BITMAPS));
    (*_TFT).DL(VERTEX2II(360, 140, 2, 0));
    (*_TFT).DL(END());

    // create link to main menu 
    MainMenuReference();
    
    // finish FT800 display list
    FinishDL();
}
