#include "display.h"

/**************************************************************************************************************************
************************** Display data about humidity in the 24-hour interval ********************************************
**************************************************************************************************************************/

void Display::StatHumidity_24hrs(volatile uint64_t seconds, short int statistics24hrs[3][288], uint64_t gridSecondsOffset)
{
    // start FT800 display list
    StartDL();
 
    // mark 8 areas for touch input (for zoom in),
    // make each every second zone gray, make the active zone green
    char ZonesCnt = 0;
    for (int i = 25; i < 433; i += 17 * 3) {
        (*_TFT).DL(COLOR_RGB(255, 255, 255));
        if (ZonesCnt % 2 == 0) {
            (*_TFT).DL(COLOR_RGB(233, 233, 233));
        }
        if (pressedButton - ZONE_1_PRESS == ZonesCnt) {
            (*_TFT).DL(COLOR_RGB(200, 255, 200));
            timePoint3hrs = 36 * ZonesCnt;
        }
        (*_TFT).DL(TAG_MASK(1));
        (*_TFT).DL(TAG(ZONE_1_PRESS + ZonesCnt));
        (*_TFT).DL(BEGIN(RECTS));
        (*_TFT).DL(VERTEX2II(i, 100, 0, 0));
        (*_TFT).DL(VERTEX2II(i + 17 * 3, 200, 0, 0));
        (*_TFT).DL(TAG_MASK(0));
        ZonesCnt++;
    }

    // create time string, GridLines, link to main menu 
    TimeSinceTurnOn(seconds);
    VerticalGrid24hrs(gridSecondsOffset);
    HorisontalGrid_Statistics_Humidity();
    MainMenuReference();
    
    // draw graph line
    (*_TFT).DL(COLOR_RGB(0, 0, 0));
    for (int i = 1; i < 287; i++) {
        short int currentValue = statistics24hrs[0][i];
        if (currentValue != INIT_STATISTICS_NUMBER) {
            char previousValue = statistics24hrs[0][i - 1];
            char delta = statistics24hrs[2][i] - statistics24hrs[1][i];
            if (delta >= DELTA_HUMIDITY) {
                (*_TFT).DL(COLOR_RGB(255, 0, 0));
                (*_TFT).DL(BEGIN(LINES));
                (*_TFT).DL(LINE_WIDTH(8));
                (*_TFT).DL(VERTEX2F(i * 23 + 25 * 16, (200 - currentValue) * 16));
                (*_TFT).DL(VERTEX2F(i * 23 + 25 * 16, (180 - currentValue) * 16));
                (*_TFT).DL(END());
                (*_TFT).DL(BEGIN(POINTS));
                (*_TFT).DL(POINT_SIZE(33));
                (*_TFT).DL(VERTEX2F(i * 23 + 25 * 16, (180 - currentValue) * 16));
                (*_TFT).DL(END());
            }
            (*_TFT).DL(COLOR_RGB(0, 0, 0));
            (*_TFT).DL(BEGIN(LINES));
            (*_TFT).DL(LINE_WIDTH(16));
            (*_TFT).DL(VERTEX2F((i - 1) * 23 + 25 * 16, (200 - previousValue) * 16));
            (*_TFT).DL(VERTEX2F(i * 23 + 25 * 16, (200 - currentValue) * 16));
            (*_TFT).DL(END());
        }
    }

    // write main title
    (*_TFT).DL(COLOR_RGB(0, 0, 0));
    (*_TFT).Text(11, 15, 30, 0, "Humidity statistics (24 hrs)");
    
    // finish FT800 display list
    FinishDL();
}

/**************************************************************************************************************************
************************** Display data about temperature in the 24-hour interval *****************************************
**************************************************************************************************************************/

void Display::StatTemperature_24hrs(volatile uint64_t seconds, short int statistics24hrs[3][288], uint64_t gridSecondsOffset)
{
    // start FT800 display list
    StartDL();
 
    // mark 8 areas for touch input (for zoom in),
    // make each every second zone gray, make the active zone green
    char ZonesCnt = 0;
    for (int i = 25; i < 433; i += 17 * 3) {
        (*_TFT).DL(COLOR_RGB(255, 255, 255));
        if (ZonesCnt % 2 == 0) {
            (*_TFT).DL(COLOR_RGB(233, 233, 233));
        }
        if (pressedButton - ZONE_1_PRESS == ZonesCnt) {
            (*_TFT).DL(COLOR_RGB(200, 255, 200));
            timePoint3hrs = 36 * ZonesCnt;
        }
        (*_TFT).DL(TAG_MASK(1));
        (*_TFT).DL(TAG(ZONE_1_PRESS + ZonesCnt));
        (*_TFT).DL(BEGIN(RECTS));
        (*_TFT).DL(VERTEX2II(i, 100, 0, 0));
        (*_TFT).DL(VERTEX2II(i + 17 * 3, 200, 0, 0));
        (*_TFT).DL(TAG_MASK(0));
        ZonesCnt++;
    }

    // create time string, GridLines, link to main menu 
    TimeSinceTurnOn(seconds);
    VerticalGrid24hrs(gridSecondsOffset);
    HorisontalGrid_Statistics_Temperature();
    MainMenuReference();
    
    // draw graph line
    (*_TFT).DL(COLOR_RGB(0, 0, 0));
    for (int i = 1; i < 287; i++) {
        char previousValue = (statistics24hrs[0][i - 1] / TEMPERATURE_MULTIPLIER + 50) * 0.57;
        char currentValue = (statistics24hrs[0][i] / TEMPERATURE_MULTIPLIER + 50) * 0.57;
        char delta = statistics24hrs[2][i] - statistics24hrs[1][i];
        if (statistics24hrs[0][i] != INIT_STATISTICS_NUMBER) {
            if (delta >= DELTA_TEMPERATURE * TEMPERATURE_MULTIPLIER) {
                (*_TFT).DL(COLOR_RGB(255, 0, 0));
                (*_TFT).DL(BEGIN(LINES));
                (*_TFT).DL(LINE_WIDTH(8));
                (*_TFT).DL(VERTEX2F(i * 23 + 25 * 16, (200 - currentValue) * 16));
                (*_TFT).DL(VERTEX2F(i * 23 + 25 * 16, (180 - currentValue) * 16));
                (*_TFT).DL(END());
                (*_TFT).DL(BEGIN(POINTS));
                (*_TFT).DL(POINT_SIZE(33));
                (*_TFT).DL(VERTEX2F(i * 23 + 25 * 16, (180 - currentValue) * 16));
                (*_TFT).DL(END());
            }
            (*_TFT).DL(COLOR_RGB(0, 0, 0));
            (*_TFT).DL(BEGIN(LINES));
            (*_TFT).DL(LINE_WIDTH(16));
            (*_TFT).DL(VERTEX2F((i - 1) * 23 + 25 * 16, (200 - previousValue) * 16));
            (*_TFT).DL(VERTEX2F(i * 23 + 25 * 16, (200 - currentValue) * 16));
        }
    }

    // write main title
    (*_TFT).DL(COLOR_RGB(0, 0, 0));
    (*_TFT).Text(11, 15, 30, 0, "Temperature statistics (24 hrs)");

    // finish FT800 display list
    FinishDL();
}