#include "mbed.h"
#include "FT_Platform.h"
#include "pictures.h"
#include "statistics.h"
#include <string>

#ifndef DISPLAY_H_
#define DISPLAY_H_

/**************************************************************************************************************************
************************** Defines using for drawing **********************************************************************
**************************************************************************************************************************/

// all tracking touch screen areas
typedef enum {
    NONE_PRESS,
    CURR_TEMP_PRESS,
    CURR_HUM_PRESS,
    STAT_TEMP_PRESS,
    STAT_HUM_PRESS,
    ZONE_1_PRESS,
    ZONE_2_PRESS,
    ZONE_3_PRESS,
    ZONE_4_PRESS,
    ZONE_5_PRESS,
    ZONE_6_PRESS,
    ZONE_7_PRESS,
    ZONE_8_PRESS,
    ABOUT_PRESS,
    MENU_PRESS,
} pressValues;

// all screens available in app
typedef enum {
    MENU_SCREEN,
    CURR_HUM_SCREEN,
    CURR_TEMP_SCREEN,
    ABOUT_SCREEN,
    HUM_24HRS_SCREEN,
    HUM_3HRS_SCREEN,
    HUM_30MIN_SCREEN,
    TEMP_24HRS_SCREEN,
    TEMP_3HRS_SCREEN,
    TEMP_30MIN_SCREEN
} screenValues;


/**************************************************************************************************************************
************************** User class for drawing at FT800 ****************************************************************
**************************************************************************************************************************/

class Display
{
public:
    // in Display class we use FT800 TFT (definition is available in main.cpp)
    Display(FT800 *TFT) {
        _TFT = TFT;
    }

    // functions describing all available screens (screens-functions)
    void MainMenu(float humidity, float temperature);                   // [display.Draw_MainMenu.cpp]
    void CurrentHumidity(float humidity);                               // [display.Draw_CurrentValues.cpp]
    void CurrentTemperature(float temperature);                         // [display.Draw_CurrentValues.cpp]
    void StatHumidity_24hrs(volatile uint64_t seconds, short int statistics24hrs[3][288], 
                                uint64_t gridSecondsOffset);            // [display.Draw_24hrsStatistics.cpp]                
    void StatTemperature_24hrs(volatile uint64_t seconds, short int statistics24hrs[3][288], 
                                uint64_t gridSecondsOffset);            // [display.Draw_24hrsStatistics.cpp]              
    void StatHumidity_3hrs(volatile uint64_t seconds, short int statistics24hrs[3][288],
                                uint64_t gridSecondsOffset);            // [display.Draw_3hrsStatistics.cpp]      
    void StatTemperature_3hrs(volatile uint64_t seconds, short int statistics24hrs[3][288], 
                                uint64_t gridSecondsOffset);            // [display.Draw_3hrsStatistics.cpp]   
    void StatHumidity_30min(volatile uint64_t seconds, short int statistics24hrs[3][288],
                                uint64_t gridSecondsOffset);            // [display.Draw_30minStatistics.cpp]      
    void StatTemperature_30min(volatile uint64_t seconds, short int statistics24hrs[3][288], 
                                uint64_t gridSecondsOffset);            // [display.Draw_30minStatistics.cpp]      
    void AboutSensor(void);                                             // [display.Draw_AboutSensor.cpp]

    // functions using to prepare FT800 / FT801
    void LoadImagesAndFonts(void);                                      // [display.LoadImagesAndFonts.cpp]
    void HandleAllBitmaps(void);                                      // [display.LoadImagesAndFonts.cpp]
    void Calibration(void);                                             // [display.Calibration.cpp]
    
    // function for touchscreen tracking
    char GetTouch(void);                                                // [display.GetTouch.cpp]    
    
    // variables using for navigation between screens
    char pressedButton;
    char activeScreen;
    char timePoint3hrs, timePoint30min;

private:
    FT800 *_TFT;

    // For start and end every display list (every screen)
    void StartDL(void);                                                 // [display.DisplayListFunctions.cpp]
    void FinishDL(void);                                                // [display.DisplayListFunctions.cpp]
    
    // Utility function for drawing
    void MainMenuReference(void);                                       // [display.Draw_MainMenuReference.cpp]
    void TimeSinceTurnOn(uint64_t seconds);                             // [display.Draw_TimeSinceTurnOn.cpp]
    void HorisontalGrid_Current_Temperature(void);                      // [display.Draw_Grids.cpp]
    void HorisontalGrid_Current_Humidity(void);                         // [display.Draw_Grids.cpp]
    void HorisontalGrid_Statistics_Temperature(void);                   // [display.Draw_Grids.cpp]
    void HorisontalGrid_Statistics_Humidity(void);                      // [display.Draw_Grids.cpp]
    void VerticalGrid3hrs(uint64_t gridSecondsOffset);                  // [display.Draw_Grids.cpp]
    void VerticalGrid24hrs(uint64_t gridSecondsOffset);                 // [display.Draw_Grids.cpp]
    void VerticalGrid30min(uint64_t gridSecondsOffset);                 // [display.Draw_Grids.cpp]

    // String operations
    char CreateStringTempHum(char *str, float number, bool isTemp);     // [display.StringsTransform.cpp]
    void CreateStringMultipliedTemp(char *str, short int number);       // [display.StringsTransform.cpp]
    void CreateStringTime(char *str, uint32_t numberOfSeconds);         // [display.StringsTransform.cpp]

    // String variables 
    char humidityStr[8], temperatureStr[8];
    char timeStr[9], gridTimeStr[9];
    
    // Variables for managing graphs with current temperature or humidity
    char currentHumidity_X, currentTemperature_X;
    char currentHumidity_Y[68], currentTemperature_Y[68];
};

#endif /* SCREENS_H_ */