#include "display.h"

/**************************************************************************************************************************
************************** Display Main Menu ******************************************************************************
**************************************************************************************************************************/

void Display::MainMenu(float humidity, float temperature)
{
     // start FT800 display list
    StartDL();
    
    // write main title
    (*_TFT).DL(COLOR_RGB(0, 0, 0));

    (*_TFT).Text(11, 15, 30, 0, "HYT-271 sensor from IST");
   
    // create blue rectangle with current humididty including 
    // rectangle is tagged as CURR_HUM_PRESS
    (*_TFT).DL(TAG_MASK(1));
    (*_TFT).DL(TAG(CURR_HUM_PRESS));
    (*_TFT).DL(COLOR_RGB(9, 0, 63));
    // if rectangle is already pressed, draw it with lighter color
    if (pressedButton == CURR_HUM_PRESS) {
        (*_TFT).DL(COLOR_RGB(75, 70, 108));
    }
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II(12 + 222 + 12, 62, 0, 0));
    (*_TFT).DL(VERTEX2II(12 + 222 + 12 + 222, 62 + 124, 0, 0));
    (*_TFT).DL(COLOR_RGB(255, 255, 255));
    (*_TFT).Text(12 + 222 + 12 + 10, 62 + 5, 29, 0, "Current");
    (*_TFT).Text(12 + 222 + 12 + 10, 62 + 35, 29, 0, "humidity (rH)");
    CreateStringTempHum(humidityStr, humidity, 0);
    (*_TFT).Text(12 + 222 + 12 + 10, 62 + 75, 31, 0, humidityStr);
    (*_TFT).DL(BEGIN(BITMAPS));
    (*_TFT).DL(VERTEX2II(12 + 222 + 10 + 180, 62 + 10, 0, 0));
    (*_TFT).DL(END());
    (*_TFT).DL(TAG_MASK(0));

    // create blue rectangle with current temperature including 
    // rectangle is tagged as CURR_TEMP_PRESS
    (*_TFT).DL(TAG_MASK(1));
    (*_TFT).DL(TAG(CURR_TEMP_PRESS));
    (*_TFT).DL(COLOR_RGB(9, 0, 63));
    // if rectangle is already pressed, draw it with lighter color
    if (pressedButton == CURR_TEMP_PRESS) {
        (*_TFT).DL(COLOR_RGB(75, 70, 108));
    }
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II(12, 62, 0, 0));
    (*_TFT).DL(VERTEX2II(12 + 222, 62 + 124, 0, 0));
    (*_TFT).DL(COLOR_RGB(255, 255, 255));
    (*_TFT).Text(12 + 10, 62 + 5, 29, 0, "Current");
    (*_TFT).Text(12 + 10, 62 + 35, 29, 0, "temperature");
    char degreeOffset = CreateStringTempHum(temperatureStr, temperature, 1);
    (*_TFT).Text(12 + 10, 62 + 75, 31, 0, temperatureStr);
    (*_TFT).Text(12 + 10 + (degreeOffset * 16 + 3), 62 + 75 - 2, 28, 0, "o");
    (*_TFT).DL(BEGIN(BITMAPS));
    (*_TFT).DL(VERTEX2II(12 + 10 + 180, 62 + 7, 1, 0));
    (*_TFT).DL(END());
    (*_TFT).DL(TAG_MASK(0));

    // create black rectangle tagged as STAT_HUM_PRESS    
    (*_TFT).DL(TAG_MASK(1));
    (*_TFT).DL(TAG(STAT_HUM_PRESS));
    (*_TFT).DL(COLOR_RGB(36, 36, 36));
    // if rectangle is already pressed, draw it with lighter color
    if (pressedButton == STAT_HUM_PRESS) {
        (*_TFT).DL(COLOR_RGB(56, 56, 56));
    }
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II(12, 62 + 124 + 12, 0, 0));
    (*_TFT).DL(VERTEX2II(12 + 144, 62 + 124 + 12 + 62, 0, 0));
    (*_TFT).DL(COLOR_RGB(255, 255, 255));
    (*_TFT).Text(12 + 10, 62 + 124 + 12 + 5, 27, 0, "Humidity");
    (*_TFT).Text(12 + 10, 62 + 124 + 12 + 30, 27, 0, "statisticss");
    (*_TFT).DL(TAG_MASK(0));

    // create black rectangle tagged as STAT_TEMP_PRESS    
    (*_TFT).DL(TAG_MASK(1));
    (*_TFT).DL(TAG(STAT_TEMP_PRESS));
    (*_TFT).DL(COLOR_RGB(36, 36, 36));
    // if rectangle is already pressed, draw it lighter
    if (pressedButton == STAT_TEMP_PRESS) {
        (*_TFT).DL(COLOR_RGB(56, 56, 56));
    }
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II(12 + 144 + 12, 62 + 124 + 12, 0, 0));
    (*_TFT).DL(VERTEX2II(12 + 144 + 12 + 144, 62 + 124 + 12 + 62, 0, 0));
    (*_TFT).DL(COLOR_RGB(255, 255, 255));
    (*_TFT).Text(12 +144 + 12 + 10, 62 + 124 + 12 + 5, 27, 0, "Temperature");
    (*_TFT).Text(12 + 144 + 12 + 10, 62 + 124 + 12 + 30, 27, 0, "statistics");
    (*_TFT).DL(TAG_MASK(0));
    
    // create black rectangle tagged as ABOUT_PRESS  
    (*_TFT).DL(TAG_MASK(1));
    (*_TFT).DL(TAG(ABOUT_PRESS));
    (*_TFT).DL(COLOR_RGB(36, 36, 36));
    // if rectangle is already pressed, draw it lighter
    if (pressedButton == ABOUT_PRESS) {
        (*_TFT).DL(COLOR_RGB(56, 56, 56));
    }
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II(12 + 144 + 12 + 144 + 12, 62 + 124 + 12, 0, 0));
    (*_TFT).DL(VERTEX2II(12 + 144 + 12 + 144 + 12 + 144, 62 + 124 + 12 + 62, 0, 0));
    (*_TFT).DL(COLOR_RGB(255, 255, 255));
    (*_TFT).Text(12 + 144 + 12 + 144 + 12 + 10, 62 + 124 + 12 + 5, 27, 0, "About");
    (*_TFT).Text(12 + 144 + 12 + 144 + 12 + 10, 62 + 124 + 12 + 30, 27, 0, "the sensor");
    (*_TFT).DL(TAG_MASK(0));
    
    // finish FT800 display list
    FinishDL();
}