#include "statistics.h"

/**************************************************************************************************************************
************************** Main function called every second **************************************************************
**************************************************************************************************************************/
uint64_t Statistics::UpdateStatistics(float humidity, float temperature, uint64_t seconds, uint64_t changeSecondsOffset)
{
    short int secondsIn5min = (seconds % 300); // 0..299
    if (secondsIn5min == 0) {
        changeSecondsOffset = Update24hrsData(changeSecondsOffset);
    }
    CalculateHumididty(humidity, secondsIn5min);
    CalculateTemperature(temperature, secondsIn5min);
    
    // changeSecondsOffset is nessesary for changing time-grid if more then 24 hours left since devise was turned on
    return changeSecondsOffset;
}

/**************************************************************************************************************************
************************** Update average, minimum and maximum humidity in current five-minute interval ****************
**************************************************************************************************************************/
void Statistics::CalculateHumididty(float humidity, short int secondsIn5min)
{
    humidity5min[secondsIn5min] = humidity;
    humidity5minSum += humidity5min[secondsIn5min];
    humidity5minAverage = humidity5minSum / (secondsIn5min + 1);

    if (humidity5min[secondsIn5min] > humidity5minMax || humidity5minMax == INIT_STATISTICS_NUMBER) {
        humidity5minMax = humidity5min[secondsIn5min];
    }
    if (humidity5min[secondsIn5min] < humidity5minMin || humidity5minMin == INIT_STATISTICS_NUMBER) {
        humidity5minMin = humidity5min[secondsIn5min];
    }
}

/**************************************************************************************************************************
************************** Update average, minimum and maximum temperature in current five-minute interval ****************
**************************************************************************************************************************/
void Statistics::CalculateTemperature(float temperature, short int secondsIn5min)
{
    // we use TEMPERATURE_MULTIPLIER = 10 for store temperatures tenths in integer values
    temperature5min[secondsIn5min] = temperature * TEMPERATURE_MULTIPLIER;
    temperature5minSum += temperature5min[secondsIn5min];
    temperature5minAverage = temperature5minSum / (secondsIn5min + 1);

    if (temperature5min[secondsIn5min] > temperature5minMax || temperature5minMax == INIT_STATISTICS_NUMBER) {
        temperature5minMax = temperature5min[secondsIn5min];
    }
    if (temperature5min[secondsIn5min] < temperature5minMin || temperature5minMin == INIT_STATISTICS_NUMBER) {
        temperature5minMin = temperature5min[secondsIn5min];
    }
}

/**************************************************************************************************************************
************************** Update humidity24hrs[][] and temperature24hrs[][] after each five-minute interval **************
**************************************************************************************************************************/
uint64_t Statistics::Update24hrsData(uint64_t changeSecondsOffset)
{
    // after each five-minute interval we moving to next value if it's availiable 
    // OR shifting the entire array and update just last value if 24 hrs are already gone 
    if (Counter24hrs < 287) {
        Counter24hrs ++;
    } else {
        for (int i = 0; i < 288; i++) {
            humidity24hrs[0][i] = humidity24hrs[0][i + 1];
            humidity24hrs[1][i] = humidity24hrs[1][i + 1];
            humidity24hrs[2][i] = humidity24hrs[2][i + 1];
            temperature24hrs[0][i] = temperature24hrs[0][i + 1];
            temperature24hrs[1][i] = temperature24hrs[1][i + 1];
            temperature24hrs[2][i] = temperature24hrs[2][i + 1];
        }
        Counter24hrs = 287;
        changeSecondsOffset += 300;
    }
    
    // update the current value 
    humidity24hrs[0][Counter24hrs] = humidity5minAverage;
    humidity24hrs[1][Counter24hrs] = humidity5minMin;
    humidity24hrs[2][Counter24hrs] = humidity5minMax;
    temperature24hrs[0][Counter24hrs] = temperature5minAverage;
    temperature24hrs[1][Counter24hrs] = temperature5minMin;
    temperature24hrs[2][Counter24hrs] = temperature5minMax;

    // initialize all values using for calculations "inside" five-minute interval
    for (int i = 0; i < 300; i++) {
        humidity5min[i] = INIT_STATISTICS_NUMBER;
        temperature5min[i] = INIT_STATISTICS_NUMBER;
    }
    humidity5minSum = 0;
    humidity5minMax = INIT_STATISTICS_NUMBER;
    humidity5minMin = INIT_STATISTICS_NUMBER;
    temperature5minSum = 0;
    temperature5minMax = INIT_STATISTICS_NUMBER;
    temperature5minMin = INIT_STATISTICS_NUMBER;
    
    // changeSecondsOffset is nessesary for changing time-grid if more then 24 hours left since devise was turned on
    return changeSecondsOffset;
}

/**************************************************************************************************************************
************************** Initialization for all statistics values and arrays ********************************************
**************************************************************************************************************************/
void Statistics::InitValues(float humidity, float temperature)
{
    for (int i = 0; i < 300; i++) {
        humidity5min[i] = INIT_STATISTICS_NUMBER;
        temperature5min[i] = INIT_STATISTICS_NUMBER;
    }
    for (int i = 0; i < 288; i++) {
        humidity24hrs[0][i] = INIT_STATISTICS_NUMBER;
        humidity24hrs[1][i] = INIT_STATISTICS_NUMBER;
        humidity24hrs[2][i] = INIT_STATISTICS_NUMBER;
        temperature24hrs[0][i] = INIT_STATISTICS_NUMBER;
        temperature24hrs[1][i] = INIT_STATISTICS_NUMBER;
        temperature24hrs[2][i] = INIT_STATISTICS_NUMBER;
    }
    humidity5min[0] = humidity;
    humidity5minMin = humidity;
    humidity5minMax = humidity;
    humidity24hrs[0][0] = humidity;
    humidity24hrs[1][0] = humidity;
    humidity24hrs[2][0] = humidity;

    temperature5min[0] = temperature * TEMPERATURE_MULTIPLIER;
    temperature5minMin = temperature * TEMPERATURE_MULTIPLIER;
    temperature5minMax = temperature * TEMPERATURE_MULTIPLIER;
    temperature24hrs[0][0] = temperature * TEMPERATURE_MULTIPLIER;
    temperature24hrs[1][0] = temperature * TEMPERATURE_MULTIPLIER;
    temperature24hrs[2][0] = temperature * TEMPERATURE_MULTIPLIER;

    Counter24hrs = 0;
}