#include "display.h"

/**************************************************************************************************************************
************************** Transform humiditity / temperature float value to string ***************************************
**************************************************************************************************************************/
// If isTemp = 0, resulting string includes
// 1. current humididty
// 3. " %"

// If isTemp = 1, resulting string includes
// 1. "-" (optional),
// 2. current temperature with decimal mark
// 3. " С"

// Returns offset using for placing degree sign
char Display::CreateStringTempHum(char *str, float number, bool isTemp)
{
    char offsetForDegreeSign;
    short int multipedNumber = (short int)(number * 100);
    char strCnt = 0;
    if (isTemp) {
        if (multipedNumber < 0) {
            multipedNumber = -multipedNumber;
            str[strCnt] = '-';
            strCnt++;
        }
    }
    if (multipedNumber >= 10000) {
        str[strCnt] = '0' + (multipedNumber % 100000) / 10000;
        strCnt++;
    }
    if (multipedNumber >= 1000) {
        str[strCnt] = '0' + (multipedNumber % 10000) / 1000;
        strCnt++;
    }
    if (multipedNumber >= 100) {
        str[strCnt] = '0' + (multipedNumber % 1000) / 100;
        strCnt++;
    }
    if (isTemp) {
        str[strCnt] = '.';
        strCnt++;
        str[strCnt] = '0' + (multipedNumber % 100) / 10;
        strCnt++;
        str[strCnt] = ' ';
        strCnt++;
        offsetForDegreeSign = strCnt;
        str[strCnt] = 'C';
        strCnt++;
    } else {
        str[strCnt] = '%';
        strCnt++;
    }
    str[strCnt] = 0;
    
    return offsetForDegreeSign;
}


/**************************************************************************************************************************
************************** Transform multiplied temperature value to string ***********************************************
**************************************************************************************************************************/
// Resulting string includes
// 1. "-" (optional),
// 2. current temperature with decimal mark
void Display::CreateStringMultipliedTemp(char *str, short int number)
{
    char strCnt = 0;
    if (number < 0) {
        number = -number;
        str[strCnt] = '-';
        strCnt++;
    }
    if (number >= 1000) {
        str[strCnt] = '0' + (number % 10000) / 1000;
        strCnt++;
    }
    if (number >= 100) {
        str[strCnt] = '0' + (number % 1000) / 100;
        strCnt++;
    }
    if (number >= 10) {
        str[strCnt] = '0' + (number % 100) / 10;
        strCnt++;
    }
    str[strCnt] = '.';
    strCnt++;
    str[strCnt] = '0' + (number % 100) / 10;
    strCnt++;
    str[strCnt] = 0;
}


/**************************************************************************************************************************
************************** Transform number of seconds to HH:MM:SS string *************************************************
**************************************************************************************************************************/
void Display::CreateStringTime(char *str, uint32_t numberOfSeconds)
{
    char hrs = (numberOfSeconds / 3600);
    if (hrs < 10) {
        str[0] = '0';
    } else {
        str[0] = '0' + hrs / 10;
    }
    str[1] = '0' + hrs % 10;
    str[2] = ':';
    char minutes = (numberOfSeconds / 60) % 60;
    if (minutes < 10) {
        str[3] = '0';
    } else {
        str[3] = '0' + minutes / 10;
    }
    str[4] = '0' + minutes % 10;
    str[5] = ':';
    char sec = numberOfSeconds % 60;
    if (sec < 10) {
        str[6] = '0';
    } else {
        str[6] = '0' + sec / 10;
    }
    str[7] = '0' + sec % 10;
    str[8] = 0;
}
