#include "mbed.h"
#include "FT_Platform.h"
#include "HYT.h"

/***********************************************************************************************************************/
/* Declare and initialize FTDI FT800 controller according to SPI lines connected */
 
//// SLSTK3400A
HYT SENSOR (PD6, PD7); // sda, scl
FT800 TFT (PE10, PE11, PE12, PE13, PB11, PD4); // mosi, miso, sck, ss, int, pd

//// WIZwiki-W7500P
//HYT SENSOR (D14, D15); // sda, scl
//FT800 TFT (D11, D12, D13, D10, D9, D8); // mosi, miso, sck, ss, int, pd

// ATSAMD21-XPRO
//HYT SENSOR (PA08, PA09); // sda, scl
//FT800 TFT (PA18, PA16, PA19, PA17, PA20, PA21); // mosi, miso, sck, ss, int, pd


/***********************************************************************************************************************/
/* HYT sensor polling cycle */
void dataUpdate(void)
{
    SENSOR.MRCommand();
    wait_ms(100);
    SENSOR.DFCommand();
}

/***********************************************************************************************************************/
/* Construct the screen and downloasd it to the TFT */
void drawTimeScreen(void)
{
    // start FT800 display list
    TFT.DLstart();
    TFT.DL(CLEAR_COLOR_RGB(255, 255, 255));
    TFT.DL(CLEAR(1, 1, 1));

    TFT.DL(COLOR_RGB(0, 0, 0));
    TFT.Text(11, 15, 30, 0, "Demo-project for habrahabr.ru");
    TFT.Text(13, 15 + 40, 28, 0, "Using FT800 library and HYT library");

    TFT.DL(COLOR_RGB(9, 40, 3));
    TFT.DL(BEGIN(RECTS));
    TFT.DL(VERTEX2II(11, 105, 0, 0));
    TFT.DL(VERTEX2II(11 + 222, 105 + 100, 0, 0));

    TFT.DL(COLOR_RGB(255, 255, 255));
    TFT.Text(11 + 10, 105 + 10, 28, 0, "Relative humidity, %");
    TFT.Number(11 + 10, 105 + 10 + 30, 31, 0, SENSOR.humidity);

    TFT.DL(COLOR_RGB(9, 3, 40));
    TFT.DL(BEGIN(RECTS));
    TFT.DL(VERTEX2II(11 + 222 + 14, 105, 0, 0));
    TFT.DL(VERTEX2II(11 + 222 + 14 + 222, 105 + 100, 0, 0));

    TFT.DL(COLOR_RGB(255, 255, 255));
    TFT.Text(11 + 222 + 14 + 10, 105 + 10, 28, 0, "Temperature, C");
    TFT.Number(11 + 222 + 14 + 10, 105 + 10 + 30, 31, 0, SENSOR.temperature);
    
    TFT.DL(COLOR_RGB(0, 0, 0));
    TFT.Text(300, 105 + 100 + 35, 28, 0, "e-mail: xk@efo.ru");
    
    TFT.DL(BEGIN(LINES));
    TFT.DL(LINE_WIDTH(8));
    TFT.DL(VERTEX2II(11, 15 + 40 + 30, 0, 0));
    TFT.DL(VERTEX2II(460, 15 + 40 + 30, 0, 0));

    // finish FT800 display list
    TFT.DL(DISPLAY());
    TFT.Swap();
}

/***********************************************************************************************************************/
/* Main function */
int main()
{
    while(1) {
        dataUpdate();
        drawTimeScreen();
    }
}