#include "mbed.h"
#include "HYT.h"

Serial              pc(USBTX, USBRX);
Ticker              timeKeeping;
// for SLSTK3400A board
HYT                 SENSOR (PD6, PD7); // sda, scl
// for WIZwiki-W7500P board
//HYT               SENSOR (D14, D15); // sda, scl
// for ATSAMD21-XPRO board
//HYT               SENSOR (PA08, PA09); // sda, scl


// HYT sensor polling cycle
void dataUpdate(void)
{
    SENSOR.MRCommand();
    wait_ms(100);
    SENSOR.DFCommand();
}

void secondsCallback(void) {
    pc.printf("Humidity level: %.1f\r\n%", SENSOR.humidity);
    pc.printf("Temperature level: %.1f\r\n%", SENSOR.temperature);
    pc.printf("-------------------------------\r\n%", SENSOR.temperature);
}

int main()
{
    timeKeeping.attach(&secondsCallback, 1.0f);
    while(1) {
        dataUpdate();
    }
}