#include "mbed.h"
#include "FT_Platform.h"

Ticker timeKeeping;
volatile uint64_t seconds = 0;

/***********************************************************************************************************************/
/* Declare and initialize FTDI FT800 controller according to SPI lines connected */
 
// SLSTK3400A
FT800 TFT (PE10, PE11, PE12, PE13, PB11, PD4); // mosi, miso, sck, ss, int, pd

// WIZwiki-W7500P
//FT800 TFT (D11, D12, D13, D10, D9, D8); // mosi, miso, sck, ss, int, pd

// ATSAMD21-XPRO
//FT800 TFT (PA18, PA16, PA19, PA17, PA20, PA21); // mosi, miso, sck, ss, int, pd


/***********************************************************************************************************************/
/* Seconds counter */
void secondsCallback(void)
{
    seconds ++;
}

/***********************************************************************************************************************/
/* Construct the screen and downloasd it to the TFT */
void drawTimeScreen(void)
{
    TFT.DLstart();
    TFT.DL(CLEAR_COLOR_RGB(255, 255, 255));
    TFT.DL(CLEAR(1, 1, 1));

    TFT.DL(COLOR_RGB(0, 0, 0));
    TFT.Text(11, 15, 30, 0, "Demo-project for habrahabr.ru");
    TFT.Text(13, 15 + 40, 28, 0, "Using FT800 library");

    TFT.DL(COLOR_RGB(9, 35, 5));
    TFT.DL(BEGIN(RECTS));
    TFT.DL(VERTEX2II(11, 105, 0, 0));
    TFT.DL(VERTEX2II(11 + 275, 105 + 100, 0, 0));

    TFT.DL(COLOR_RGB(255, 255, 255));
    TFT.Text(11 + 10, 105 + 10, 29, 0, "Number of seconds:");
    TFT.Number(11 + 10, 105 + 10 + 30, 31, 0, seconds);
    
    TFT.Clock(390, 105 + 70, 70, 0, 4, 20, (seconds % 60), 0);
    
    TFT.DL(COLOR_RGB(0, 0, 0));
    TFT.Text(11, 240, 28, 0, "e-mail: xk@efo.ru");
    
    TFT.DL(BEGIN(LINES));
    TFT.DL(LINE_WIDTH(8));
    TFT.DL(VERTEX2II(11, 15 + 40 + 30, 0, 0));
    TFT.DL(VERTEX2II(460, 15 + 40 + 30, 0, 0));
    
    TFT.DL(DISPLAY());
    TFT.Swap();
}

/***********************************************************************************************************************/
/* Main function */
int main()
{
    timeKeeping.attach(&secondsCallback, 1.0f);
    while(1) {
        drawTimeScreen();
    }
}