#include "mbed.h"
#include "FT_Platform.h"

// SLSTK3400A
FT800 TFT (PE10, PE11, PE12, PE13, PB11, PD4); // mosi, miso, sck, ss, int, pd
// WIZwiki-W7500P
//FT800 TFT (D11, D12, D13, D10, D9, D8); // mosi, miso, sck, ss, int, pd
// ATSAMD21-XPRO
//FT800 TFT (PA18, PA16, PA19, PA17, PA20, PA21); // mosi, miso, sck, ss, int, pd

char sliderVal = 0;

/***********************************************************************************************************************/
/* Construct the screen and downloasd it to the TFT */
void drawScreen()
{
    TFT.DLstart();
    TFT.DL(CLEAR_COLOR_RGB(255, 255, 255));
    TFT.DL(CLEAR(1, 1, 1));
    
    TFT.FgColor(0xC1004D);
    
    TFT.Keys(27, 127, 271, 41, 29, 0, "123");
    
    TFT.DL(TAG(1));
    TFT.Button(31, 32, 148, 57, 27, OPT_FLAT, "Button");
    
    TFT.DL(TAG(2));
    TFT.Slider(244, 45, 161, 17, 0, sliderVal, 255);
    
    // track the touch screen
    char pressedButton = TFT.Rd8(REG_TOUCH_TAG);
    int pressedSlider = TFT.Rd32(REG_TRACKER);
    if (pressedButton == 2) {
        sliderVal = (pressedSlider >> 16) * 255 / 65536;
    }
    
    TFT.DL(COLOR_RGB(0, 0, 0));
    TFT.Text(28, 213, 28, 0, "REG_TOUCH_TAG");
    TFT.Text(28, 237, 28, 0, "REG_TRACKER");
    TFT.Number(230, 237, 28, 0, pressedButton);
    TFT.Number(230, 213, 28, 0, sliderVal);
    
    TFT.DL(DISPLAY());
    TFT.Swap();
    TFT.Flush_Co_Buffer();
    TFT.WaitCmdfifo_empty();
}

/***********************************************************************************************************************/
/* Main function */
int main()
{
    TFT.Calibrate();
    TFT.Track(244, 45, 161, 17, 2);
    while(1) {
        drawScreen();
    }
}