#include "Display.h"


/**************************************************************************************************************************
************************** Decompress images anf fonts from pictures.h and put them to the RAM memeory of FT800 ***********
**************************************************************************************************************************/
void Display::LoadImagesAndFonts()
{
    (*_TFT).WrCmd32(CMD_INFLATE);
    (*_TFT).WrCmd32(FONT_SET_ROBOTO_REGULAR_16);
    (*_TFT).WrCmdBufFromFlash(font_RobotoRegular16, sizeof(font_RobotoRegular16));
}

/**************************************************************************************************************************
************************** Prepare images and fronts **********************************************************************
**************************************************************************************************************************/
void Display::HandleAllBitmaps()
{
     // start FT800 display list
    StartDL();

    (*_TFT).DL(BITMAP_HANDLE(4));
    (*_TFT).DL(BITMAP_SOURCE(FONT_ADDR_ROBOTO_REGULAR_16));
    (*_TFT).DL(BITMAP_LAYOUT(L4, 8, 20));
    (*_TFT).DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 16, 20));
    
    (*_TFT).SetFont(4, FONT_SET_ROBOTO_REGULAR_16);
   
    // finish FT800 display list
    FinishDL();
}
