#include "mbed.h"
#include "FT_Platform.h"
#include "HYT.h"
#include "Display.h"

HYT         SENSOR(PD6, PD7); // sda, scl [efm32hg_stk3400]
FT800       TFT(PE10, PE11, PE12, PE13, PA1, PB11); // mosi, miso, sck, ss, int, pd [efm32hg_stk3400]
AnalogIn    ADC(PD4); // [efm32hg_stk3400]

Display     disp(&TFT);

uint8_t     humidity;
float       flow;
int8_t      temperature;

#define HUMIDITY_CORRECTION         15
#define TEMPERATURE_CORRECTION      -1

/*************************************************************************************************************************/
float calculateFlow(uint16_t resultADC)
{
    uint16_t flowVoltage;
    if ((resultADC / 1000) - 32 >= 0) {
        flowVoltage = (resultADC / 1000) - 32;
    } else {
        flowVoltage = 0;
    }
      
    float voltageToSpeed[31] = { 0, 0, 0, 0.1, 0.1, 0.1, 0.2, 0.2, 0.3, 0.3,
                                 0.4, 0.5, 0.6, 0.7, 0.8, 1.0, 1.2, 1.5, 2.0, 2.3, 2.8, 3.2, 3.9,
                                 4.5, 5.1, 5.8, 6.5, 7.4, 8.2, 9.1, 10
                               };
    float flowSpeed = voltageToSpeed[flowVoltage];

    return flowSpeed;
}

/*************************************************************************************************************************/
uint8_t calculateHumidity(uint8_t humidityFromHYT)
{
    uint8_t humidityFinal;
    if (humidityFromHYT + 15 >= 100) {
        humidityFinal = 100;
    } else {
        humidityFinal = humidityFromHYT + HUMIDITY_CORRECTION;
    }

    return humidityFinal;
}

/*************************************************************************************************************************/
int8_t calculateTemperature(int8_t temperatureFromHYT)
{
    return temperatureFromHYT + TEMPERATURE_CORRECTION;
}

/**************************************************************************************************************************/
int main()
{
    disp.Calibration();

    disp.LoadImagesAndFonts();
    disp.HandleAllBitmaps();

    disp.showHumidity = 1;
    disp.showFlow = 1;
    disp.showTemperature = 1;

    // first point
    SENSOR.MRCommand();
    wait_ms(100);
    SENSOR.DFCommand();
    
    while (1) {
        SENSOR.MRCommand();

        humidity = calculateHumidity((uint8_t) SENSOR.humidity);
        flow = calculateFlow(ADC.read_u16());
        temperature = calculateTemperature((int8_t) SENSOR.temperature);

        disp.UpdateDataToDraw(humidity, temperature, flow);
        disp.MainScreen();

        disp.GetTouch();

        SENSOR.DFCommand();
    }
}
