#include "Display.h"

/*************************************************************************************************************************/
void Display::UpdateDataToDraw(uint8_t humidity, int8_t temperature, float flow)
{        
    if (current_X >= POINTS_NUMBER) {
        current_X = 0;
    } else {
        current_X ++;
    }
    
    flow_Y[current_X] = flow * 20;
    humidity_Y[current_X] = humidity * 2;
    temperature_Y[current_X] = (temperature + 10) * 4;
    
    flow_Y[current_X] = flow_Y[current_X] + Y_BOTTOM_OFFSET;
    humidity_Y[current_X] = humidity_Y[current_X] + Y_BOTTOM_OFFSET;
    temperature_Y[current_X] = temperature_Y[current_X] + Y_BOTTOM_OFFSET;
    
    CreateStringHumidity(humidityStr, humidity);
    CreateStringFlow(flowStr, flow);
    CreateStringTemperature(temperatureStr, temperature);
}
