#include "Display.h"

/**************************************************************************************************************************
************************** Draw horisontal grid w/o legend ***************************************************
**************************************************************************************************************************/
void Display::HorisontalGrid()
{
    (*_TFT).DL(COLOR_RGB(150, 150, 150));
    for (int i = 0; i <= 200; i += 40) {
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(LINE_WIDTH(8));
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET, my_DispHeight - (i + Y_BOTTOM_OFFSET), 0, 0));
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + (POINTS_NUMBER * X_AXIS_MULTIPLIER + 5), my_DispHeight - (i + Y_BOTTOM_OFFSET), 0, 0));
    }
}

/**************************************************************************************************************************
************************** Draw horisontal grid for temperature (-10 .. +40) *********************************************
**************************************************************************************************************************/
void Display::HorisontalGrid_Temperature()
{
    (*_TFT).DL(COLOR_RGB(20, 20, 20));
    int8_t gridNumb = -10;
    for (int i = 0; i <= 200; i += 40) {
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(LINE_WIDTH(8));
        if (gridNumb == 0) {
            (*_TFT).DL(LINE_WIDTH(11));
        }
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET, my_DispHeight - (i + Y_BOTTOM_OFFSET), 0, 0));
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + (POINTS_NUMBER * X_AXIS_MULTIPLIER + 5), my_DispHeight - (i + Y_BOTTOM_OFFSET), 0, 0));
        if (gridNumb < 0) {
            (*_TFT).Text((POINTS_NUMBER * X_AXIS_MULTIPLIER + 18), my_DispHeight - (i + Y_BOTTOM_OFFSET + 8), 26, 0, "-");
            (*_TFT).Number((POINTS_NUMBER * X_AXIS_MULTIPLIER + 23), my_DispHeight - (i + Y_BOTTOM_OFFSET + 8), 26, 0, (-gridNumb));
        } else {
            (*_TFT).Number((POINTS_NUMBER * X_AXIS_MULTIPLIER + 18), my_DispHeight - (i + Y_BOTTOM_OFFSET + 8), 26, 0, gridNumb);
        }
        gridNumb = gridNumb + 10;
    }
}

/**************************************************************************************************************************
************************** Draw horisontal grid for humidity (0 .. 100) ***************************************************
**************************************************************************************************************************/
void Display::HorisontalGrid_Humidity()
{
    (*_TFT).DL(COLOR_RGB(20, 20, 20));
    uint8_t gridNumb = 0;
    for (int i = 0; i <= 200; i += 40) {
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(LINE_WIDTH(8));
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET, my_DispHeight - (i + Y_BOTTOM_OFFSET), 0, 0));
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + (POINTS_NUMBER * X_AXIS_MULTIPLIER + 5), my_DispHeight - (i + Y_BOTTOM_OFFSET), 0, 0));
        (*_TFT).Number((POINTS_NUMBER * X_AXIS_MULTIPLIER + 18), my_DispHeight - (i + Y_BOTTOM_OFFSET + 8), 26, 0, gridNumb);
        gridNumb = gridNumb + 20;
    }
}

/**************************************************************************************************************************
************************** Draw horisontal grid for flow (0.0 .. 10.0) ***************************************************
**************************************************************************************************************************/
void Display::HorisontalGrid_Flow()
{
    (*_TFT).DL(COLOR_RGB(20, 20, 20));
    uint8_t gridNumb = 0;
    for (int i = 0; i <= 200; i += 40) {
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(LINE_WIDTH(8));
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET, my_DispHeight - (i + Y_BOTTOM_OFFSET), 0, 0));
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + (POINTS_NUMBER * X_AXIS_MULTIPLIER + 5), my_DispHeight - (i + Y_BOTTOM_OFFSET), 0, 0));
        (*_TFT).Number((POINTS_NUMBER * X_AXIS_MULTIPLIER + 18), my_DispHeight - (i + Y_BOTTOM_OFFSET + 8), 26, 0, gridNumb);
        gridNumb = gridNumb + 2;
    }
}

/**************************************************************************************************************************
************************** Draw vertical grid *****************************************************************************
**************************************************************************************************************************/
void Display::VerticalGrid()
{
    (*_TFT).DL(COLOR_RGB(200, 200, 200));
    for (int i = 0; i <= POINTS_NUMBER; i += 10) {
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(LINE_WIDTH(8));
        (*_TFT).DL(VERTEX2II(i * X_AXIS_MULTIPLIER + X_LEFT_OFFSET, my_DispHeight - Y_BOTTOM_OFFSET - 200, 0, 0));
        (*_TFT).DL(VERTEX2II(i * X_AXIS_MULTIPLIER + X_LEFT_OFFSET, my_DispHeight - Y_BOTTOM_OFFSET, 0, 0));
    }
}
