#include "mbed.h"
#include "FT_Platform.h"
#include "fonts.h"
#include <string>

#ifndef DISPLAY_H_
#define DISPLAY_H_

#define X_AXIS_MULTIPLIER   6
#define POINTS_NUMBER       70

#define Y_BOTTOM_OFFSET     17
#define Y_UPPER_OFFSET      10
#define X_LEFT_OFFSET       10

#define BUTTON_1_WIDTH      136
#define BUTTON_2_WIDTH      145
#define BUTTON_3_WIDTH      120
#define BUTTON_HEIGHT       30

#define SET_FLOW_COLOR              COLOR_RGB(100,46,79)
#define SET_HUMIDITY_COLOR          COLOR_RGB(52,67,94)
#define SET_TEMPERATURE_COLOR       COLOR_RGB(40,66,36)

#define SET_FLOW_LOW_COLOR          COLOR_RGB(66,40,52)
#define SET_HUMIDITY_LOW_COLOR      COLOR_RGB(33,43,61)
#define SET_TEMPERATURE_LOW_COLOR   COLOR_RGB(20,34,18)

#define SET_GRAY_COLOR              COLOR_RGB(100,100,100)
#define SET_WHITE_COLOR             COLOR_RGB(255,255,255)

#define SET_BACKGROUND_COLOR        COLOR_RGB(240,240,240)

#define CLEAR_BACKGROUND_COLOR      CLEAR_COLOR_RGB(240,240,240)
#define BACKGROUND_COLOR            0xF0F0F0

/**************************************************************************************************************************
************************** Defines using for drawing **********************************************************************
**************************************************************************************************************************/

// all tracking touch screen areas
typedef enum {
    NONE_PRESS,
    SHOW_HUMIDITY,
    SHOW_FLOW,
    SHOW_TEMPERATURE
} pressValues;


/**************************************************************************************************************************
************************** User class for drawing at FT800 ****************************************************************
**************************************************************************************************************************/

class Display
{
public:
    // in Display class we use FT800 TFT (definition is available in main.cpp)
    Display(FT800 *TFT) {
        _TFT = TFT;
    }

    void UpdateDataToDraw(uint8_t humidity, int8_t temperature, float flow);

    // functions describing all available screens (screens-functions)
    void MainScreen();   // [display.Draw_MainScreen.cpp]

    // functions using to prepare FT800
    void Calibration(void);                             // [display.Calibration.cpp]
    
    void LoadImagesAndFonts(void);                                      // [display.LoadImagesAndFonts.cpp]
    void HandleAllBitmaps(void);                                      // [display.LoadImagesAndFonts.cpp]
    
    // functions for touch screen tracking
    void GetTouch(void);                                // [display.GetTouch.cpp]

    uint8_t pressedButton, buttonPressedPrev;
    bool showHumidity, showFlow, showTemperature;

private:
    FT800 *_TFT;

    void StartDL(void);                                 // [display.DisplayListFunctions.cpp]
    void FinishDL(void);                                // [display.DisplayListFunctions.cpp]
    
    void VerticalGrid(void);
    void HorisontalGrid(void);
    void HorisontalGrid_Temperature(void);              // [display.Draw_Grids.cpp]
    void HorisontalGrid_Humidity(void);                 // [display.Draw_Grids.cpp]
    void HorisontalGrid_Flow(void);                     // [display.Draw_Grids.cpp]


    void CreateStringHumidity(char *str, uint8_t humidity);       // [display.StringsTransforming.cpp]
    void CreateStringFlow(char *str, float flow);       // [display.StringsTransforming.cpp]
    void CreateStringTemperature(char *str, int8_t temperature);       // [display.StringsTransforming.cpp]
    void CreateStringRussian(const string rustext);                     // [display.StringsTransform.cpp]
           
    char humidityStr[8], temperatureStr[8], flowStr[8];
    char russianStr[150];
        
    uint8_t current_X;
    int humidity_Y[POINTS_NUMBER + 1], temperature_Y[POINTS_NUMBER + 1], flow_Y[POINTS_NUMBER + 1];
};

#endif /* DISPLAY_H_ */
