#include "Display.h"

/*************************************************************************************************************************/
void Display::CreateStringRussian(const string rustext)
{
// CHANGED ASCII:
//  0123456789АБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя.,:-°±%<>rHYTICS
    int len = rustext.length();
    int j = 0;
    for (int i = 0; i < len; i ++) {
        uint16_t res = uint8_t(rustext[i]);
        if (res > 0x7F) {
            res = res << 8 | uint8_t(rustext[i + 1]);
            // АБВ ... ноп
            if ((res >= 0xD090) && (res <= 0xD0BF)) {
                char offset = (char)(res - 0xD090);
                russianStr[j] = 32 + 11 + offset;
            // рст ... эюя
            } else if ((res >= 0xD180) && (res <= 0xD18F)) {
                char offset = (char)(res - 0xD180);
                russianStr[j] = 32 + 59 + offset;
            }
            // Degree sign
            else if (res == 0xC2B0) {
                russianStr[j] = 32 + 79;
            }
            // Plus-minus sign
            else if (res == 0xC2B1) {
                russianStr[j] = 32 + 80;
            }
            i++;
        } else {
            // Space
            if (res == 0x20) {
                russianStr[j] = 32;
            } 
            // Numbers
            else if (res >= 0x30 && res <= 0x39) {  
                russianStr[j] = 32 + 1 + (res - 0x30);
            } 
            // .
            else if (res == 0x2E) {
                russianStr[j] = 32 + 75;
            }
            // ,
            else if (res == 0x2C) {
                russianStr[j] = 32 + 76;
            }
            // :
            else if (res == 0x3A) {
                russianStr[j] = 32 + 77;
            }
            // -
            else if (res == 0x2D) {
                russianStr[j] = 32 + 78;
            }
            // %
            else if (res == 0x25) {
                russianStr[j] = 32 + 81;
            } 
            // <
            else if (res == 0x3C) {
                russianStr[j] = 32 + 82;
            }
            // >
            else if (res == 0x3C) {
                russianStr[j] = 32 + 83;
            }
            // "r"
            else if (res == 0x72) {
                russianStr[j] = 32 + 84;
            }
            // "H"
            else if (res == 0x48) {
                russianStr[j] = 32 + 85;
            }
            // "Y"
            else if (res == 0x59) {
                russianStr[j] = 32 + 86;
            }
            // "T"
            else if (res == 0x54) {
                russianStr[j] = 32 + 87;
            }
            // "I"
            else if (res == 0x49) {
                russianStr[j] = 32 + 88;
            }
            // "C"
            else if (res == 0x43) {
                russianStr[j] = 32 + 89;
            }
            // "S"
            else if (res == 0x53) {
                russianStr[j] = 32 + 90;
            }
        }
        j++;
    }
    russianStr[j] = 0;
}

/*************************************************************************************************************************/
void Display::CreateStringHumidity(char *str, uint8_t humidity)
{
    uint8_t strCnt = 0;
    if (humidity == 100) {
        str[strCnt] = 32 + 2;
        strCnt++;
    }
    if (humidity >= 10) {
        str[strCnt] = 32 + 1 + humidity / 10;
        strCnt++;
    }
    str[strCnt] = 32 + 1 + humidity % 10;
    strCnt++;
    str[strCnt] = 32 + 81;
    strCnt++;
//    str[strCnt] = 32 + 84;
//    strCnt++;
//    str[strCnt] = 32 + 85;
//    strCnt++;
    str[strCnt] = 0;
}

/*************************************************************************************************************************/
void Display::CreateStringFlow(char *str, float flow)
{
    int8_t multipedFlow = (int8_t)(flow * 10);
    uint8_t strCnt = 0;
    if (multipedFlow == 100) {
        str[strCnt] = 32 + 2;
        strCnt++;
    }
    if (multipedFlow >= 10) {
        str[strCnt] = 32 + 1 + multipedFlow / 10;
    } else {
        str[strCnt] = 32 + 1;
    }
    strCnt++;
    str[strCnt] = 32 + 75;
    strCnt++;
    str[strCnt] = 32 + 1 + multipedFlow % 10;
    strCnt++;
    str[strCnt] = 32;
    strCnt++;
    str[strCnt] = 32 + 55;
    strCnt++;
    str[strCnt] = 32 + 86;
    strCnt++;
    str[strCnt] = 32 + 60;
    strCnt++;
    str[strCnt] = 0;
}

/*************************************************************************************************************************/
void Display::CreateStringTemperature(char *str, int8_t temperature)
{
    int8_t strCnt = 0;
    if (temperature < 0) {
        temperature = -temperature;
        str[strCnt] = 32 + 78;
        strCnt++;
    }
    if (temperature >= 10) {
        str[strCnt] = 32 + 1 + temperature / 10;
        strCnt++;
    }
    str[strCnt] = 32 + 1 + temperature % 10;
    strCnt++;
    str[strCnt] = 32 + 79;
    strCnt++;
    str[strCnt] = 32 + 87;
    strCnt++;
    str[strCnt] = 0;
}
