#include "Display.h"

/**************************************************************************************************************************
************************** Display Main Menu ******************************************************************************
**************************************************************************************************************************/
void Display::MainScreen()
{
    uint8_t numberOfGraphs = showHumidity + showFlow + showTemperature;

    // start FT800 display list
    StartDL();

    /****************************************************************************************************/
    (*_TFT).DL(SET_BACKGROUND_COLOR);
    (*_TFT).DL(TAG_MASK(1));
    (*_TFT).DL(TAG(SHOW_HUMIDITY));
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II(0, 0, 0, 0));
    (*_TFT).DL(VERTEX2II(0 + BUTTON_1_WIDTH + X_LEFT_OFFSET, Y_UPPER_OFFSET + BUTTON_HEIGHT + Y_UPPER_OFFSET, 0, 0));
    (*_TFT).DL(END());
    (*_TFT).DL(TAG_MASK(0));

    (*_TFT).DL(TAG_MASK(1));
    (*_TFT).DL(TAG(SHOW_FLOW));
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + BUTTON_1_WIDTH + X_LEFT_OFFSET / 2, 0, 0, 0));
    (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + BUTTON_1_WIDTH + X_LEFT_OFFSET + BUTTON_2_WIDTH + X_LEFT_OFFSET / 2, Y_UPPER_OFFSET + BUTTON_HEIGHT + Y_UPPER_OFFSET, 0, 0));
    (*_TFT).DL(END());
    (*_TFT).DL(TAG_MASK(0));

    (*_TFT).DL(TAG_MASK(1));
    (*_TFT).DL(TAG(SHOW_TEMPERATURE));
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + BUTTON_1_WIDTH + X_LEFT_OFFSET + BUTTON_2_WIDTH + X_LEFT_OFFSET / 2, 0, 0, 0));
    (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + BUTTON_1_WIDTH + X_LEFT_OFFSET + BUTTON_2_WIDTH + X_LEFT_OFFSET + BUTTON_3_WIDTH + X_LEFT_OFFSET / 2, Y_UPPER_OFFSET + BUTTON_HEIGHT + Y_UPPER_OFFSET, 0, 0));
    (*_TFT).DL(END());
    (*_TFT).DL(TAG_MASK(0));

    /****************************************************************************************************/
    if (showHumidity) {
        (*_TFT).DL(SET_HUMIDITY_COLOR);
    } else {
        (*_TFT).DL(SET_HUMIDITY_LOW_COLOR);
    }
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET, Y_UPPER_OFFSET, 0, 0));
    (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + BUTTON_1_WIDTH, Y_UPPER_OFFSET + BUTTON_HEIGHT, 0, 0));
    (*_TFT).DL(END());
    if (showHumidity) {
        (*_TFT).DL(SET_HUMIDITY_LOW_COLOR);
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET, Y_UPPER_OFFSET + BUTTON_HEIGHT, 0, 0));
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + BUTTON_1_WIDTH, Y_UPPER_OFFSET + BUTTON_HEIGHT, 0, 0));
        (*_TFT).DL(END());
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET, Y_UPPER_OFFSET, 0, 0));
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET, Y_UPPER_OFFSET + BUTTON_HEIGHT, 0, 0));
        (*_TFT).DL(END());
        (*_TFT).DL(SET_WHITE_COLOR);
    } else {
        (*_TFT).DL(COLOR_RGB(100, 100, 100));
    }
    CreateStringRussian("Отн. влажность");
    (*_TFT).Text(X_LEFT_OFFSET + 5, Y_UPPER_OFFSET + 5, 4, 0, russianStr);


    (*_TFT).DL(SET_FLOW_COLOR);
    if (showFlow)
        (*_TFT).DL(SET_FLOW_COLOR);
    else
        (*_TFT).DL(SET_FLOW_LOW_COLOR);
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + BUTTON_1_WIDTH + X_LEFT_OFFSET, Y_UPPER_OFFSET, 0, 0));
    (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + BUTTON_1_WIDTH + X_LEFT_OFFSET + BUTTON_2_WIDTH, Y_UPPER_OFFSET + BUTTON_HEIGHT, 0, 0));
    (*_TFT).DL(END());
    if (showFlow) {
        (*_TFT).DL(SET_FLOW_LOW_COLOR);
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + BUTTON_1_WIDTH + X_LEFT_OFFSET, Y_UPPER_OFFSET + BUTTON_HEIGHT, 0, 0));
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + BUTTON_1_WIDTH + X_LEFT_OFFSET + BUTTON_2_WIDTH, Y_UPPER_OFFSET + BUTTON_HEIGHT, 0, 0));
        (*_TFT).DL(END());
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + BUTTON_1_WIDTH + X_LEFT_OFFSET, Y_UPPER_OFFSET, 0, 0));
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + BUTTON_1_WIDTH + X_LEFT_OFFSET, Y_UPPER_OFFSET + BUTTON_HEIGHT, 0, 0));
        (*_TFT).DL(END());
        (*_TFT).DL(SET_WHITE_COLOR);
    } else {
        (*_TFT).DL(COLOR_RGB(100, 100, 100));
    }
    CreateStringRussian("Скорость потока");
    (*_TFT).Text(X_LEFT_OFFSET + BUTTON_1_WIDTH + X_LEFT_OFFSET + 5, Y_UPPER_OFFSET + 5, 4, 0, russianStr);


    if (showTemperature)
        (*_TFT).DL(SET_TEMPERATURE_COLOR);
    else
        (*_TFT).DL(SET_TEMPERATURE_LOW_COLOR);
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + BUTTON_1_WIDTH + X_LEFT_OFFSET + BUTTON_2_WIDTH + X_LEFT_OFFSET, Y_UPPER_OFFSET, 0, 0));
    (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + BUTTON_1_WIDTH + X_LEFT_OFFSET + BUTTON_2_WIDTH + X_LEFT_OFFSET + BUTTON_3_WIDTH, Y_UPPER_OFFSET + BUTTON_HEIGHT, 0, 0));
    (*_TFT).DL(END());
    if (showTemperature) {
        (*_TFT).DL(SET_TEMPERATURE_LOW_COLOR);
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + BUTTON_1_WIDTH + X_LEFT_OFFSET + BUTTON_2_WIDTH + X_LEFT_OFFSET, Y_UPPER_OFFSET + BUTTON_HEIGHT, 0, 0));
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + BUTTON_1_WIDTH + X_LEFT_OFFSET + BUTTON_2_WIDTH + X_LEFT_OFFSET + BUTTON_3_WIDTH, Y_UPPER_OFFSET + BUTTON_HEIGHT, 0, 0));
        (*_TFT).DL(END());
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + BUTTON_1_WIDTH + X_LEFT_OFFSET + BUTTON_2_WIDTH + X_LEFT_OFFSET, Y_UPPER_OFFSET, 0, 0));
        (*_TFT).DL(VERTEX2II(X_LEFT_OFFSET + BUTTON_1_WIDTH + X_LEFT_OFFSET + BUTTON_2_WIDTH + X_LEFT_OFFSET, Y_UPPER_OFFSET + BUTTON_HEIGHT, 0, 0));
        (*_TFT).DL(END());
        (*_TFT).DL(SET_WHITE_COLOR);
    } else {
        (*_TFT).DL(COLOR_RGB(100, 100, 100));
    }
    CreateStringRussian("Температура");
    (*_TFT).Text(X_LEFT_OFFSET + BUTTON_1_WIDTH + X_LEFT_OFFSET + BUTTON_2_WIDTH + X_LEFT_OFFSET + 5, Y_UPPER_OFFSET + 5, 4, 0, russianStr);


/****************************************************************************************************/
    if (showTemperature) {
        (*_TFT).DL(BEGIN(EDGE_STRIP_B));
        for (int i = 0; i <= POINTS_NUMBER; i++) {
            if (i <= current_X) {
                (*_TFT).DL(COLOR_RGB(210,255,2016));
                (*_TFT).DL(VERTEX2II((i * X_AXIS_MULTIPLIER + X_LEFT_OFFSET), my_DispHeight - temperature_Y[i], 0, 0));
            }
        }
    }
    if (showHumidity) {
        (*_TFT).DL(BEGIN(EDGE_STRIP_B));
        for (int i = 0; i <= POINTS_NUMBER; i++) {
            if (i <= current_X) {
                (*_TFT).DL(COLOR_RGB(184,213,255));
                (*_TFT).DL(VERTEX2II((i * X_AXIS_MULTIPLIER + X_LEFT_OFFSET), my_DispHeight - humidity_Y[i], 0, 0));
            }
        }
    }
    if (showFlow) {
        (*_TFT).DL(BEGIN(EDGE_STRIP_B));
        for (int i = 0; i <= POINTS_NUMBER; i++) {
            if (i <= current_X) {
                (*_TFT).DL(COLOR_RGB(255,198,255));
                (*_TFT).DL(VERTEX2II((i * X_AXIS_MULTIPLIER + X_LEFT_OFFSET), my_DispHeight - flow_Y[i], 0, 0));
            }
        }
    }

/****************************************************************************************************/
    if (numberOfGraphs != 1) {
        HorisontalGrid();
    } else {
        if (showHumidity)
            HorisontalGrid_Humidity();
        if (showFlow)
            HorisontalGrid_Flow();
        if (showTemperature)
            HorisontalGrid_Temperature();
    }
    
    VerticalGrid();

/****************************************************************************************************/
    for (int i = 0; i <= POINTS_NUMBER; i++) {
        (*_TFT).DL(BEGIN(POINTS));
        (*_TFT).DL(POINT_SIZE(40));
        if (i <= current_X || i >= current_X + 13) {
            (*_TFT).DL(SET_HUMIDITY_COLOR);
            if (showHumidity)
                (*_TFT).DL(VERTEX2II((i * X_AXIS_MULTIPLIER + X_LEFT_OFFSET), my_DispHeight - humidity_Y[i], 0, 0));
            (*_TFT).DL(SET_FLOW_COLOR);
            if (showFlow)
                (*_TFT).DL(VERTEX2II((i * X_AXIS_MULTIPLIER + X_LEFT_OFFSET), my_DispHeight - flow_Y[i], 0, 0));
            (*_TFT).DL(SET_TEMPERATURE_COLOR);
            if (showTemperature)
                (*_TFT).DL(VERTEX2II((i * X_AXIS_MULTIPLIER + X_LEFT_OFFSET), my_DispHeight - temperature_Y[i], 0, 0));
        }
        (*_TFT).DL(END());
    }

/****************************************************************************************************/
    (*_TFT).DL(SET_HUMIDITY_COLOR);
    if (showHumidity)
        (*_TFT).Text((current_X * X_AXIS_MULTIPLIER + X_LEFT_OFFSET), my_DispHeight - humidity_Y[current_X] - 25, 4, 0, humidityStr);
    (*_TFT).DL(SET_FLOW_COLOR);
    if (showFlow)
        (*_TFT).Text((current_X * X_AXIS_MULTIPLIER + X_LEFT_OFFSET), my_DispHeight - flow_Y[current_X] - 25, 4, 0, flowStr);
    (*_TFT).DL(SET_TEMPERATURE_COLOR);
    if (showTemperature)
        (*_TFT).Text((current_X * X_AXIS_MULTIPLIER + X_LEFT_OFFSET), my_DispHeight - temperature_Y[current_X] - 25, 4, 0, temperatureStr);

/****************************************************************************************************/
//    (*_TFT).Number(my_DispWidth - 25, my_DispHeight - 150, 27, 0, sec / 60);
//    (*_TFT).Number(my_DispWidth - 25, my_DispHeight - 135, 27, 0, sec % 60);

/****************************************************************************************************/
    (*_TFT).DL(SCISSOR_XY(0, my_DispHeight - Y_BOTTOM_OFFSET + 3));
    (*_TFT).DL(SCISSOR_SIZE(X_LEFT_OFFSET + (POINTS_NUMBER * X_AXIS_MULTIPLIER + 5), Y_BOTTOM_OFFSET - 3));
    (*_TFT).Gradient(0, my_DispHeight, BACKGROUND_COLOR, X_LEFT_OFFSET + (POINTS_NUMBER * X_AXIS_MULTIPLIER + 5), my_DispHeight - Y_BOTTOM_OFFSET + 3, BACKGROUND_COLOR);


    // finish FT801 display list
    FinishDL();
}
