#include "mbed.h"
#include "camera_api.h"

#define clk 2  //ms
 
 BX_camera::BX_camera(void){
     
           line_CamR = new FastAnalogIn(PTD5);
           line_CamL=   new FastAnalogIn(PTD6,0);  
           cam_clk=new DigitalOut(PTE1);
           si=new DigitalOut(PTD7);

     }
 
int BX_camera::black_centerR(void){
       
         // find center 
         // case 1      //  |  //
         // case 2       /  |  /
    
     char find_type=0x00;
     
     int b_end=0;
     int b_start=0;
     
     int b2_end=0;
     int b2_start=0;
     
     
     int center;
     int j=64;
     bool f1=false;
     bool f2=false;
     bool f3=false;
     bool f4=false;
    
         
            if(sign_line_imageR[64]==' ')
              find_type=0x02;
            else
              find_type=0x01;  
            
          
           for(int i=64;i<128; i++,j--){
               
                
               switch(find_type){
                   
                   
                   case 0x01:
                       
                         if(f1==false&&sign_line_imageR[i]==' '){ 
                                  if(f1==false){
                                      b_start=i;
                                      f1=true;
                                  }
                                  
                         }
                         if(f1== true&& f2==false&&sign_line_imageR[i]=='O'){ 
                                  if(f2==false){
                                      b_end=i-1;
                                      f2=true;
                                  }
                                  
                         }
                         
                         if(f3==false&&sign_line_imageR[j]==' '){ 
                                  if(f3==false){
                                      b2_end=j;
                                      f3=true;
                                  }
                                  
                         }
                         if(f3==true&&f4==false&&sign_line_imageR[j]=='O'){ 
                                  if(f4==false){
                                      b2_start=j-1;
                                      f4=true;
                                  }
                                  
                         }
                         
                   
                   break;
                   
                   
                   case 0x02:
                   
                         if(sign_line_imageR[i]=='O'){         
                    
                                  if(f1==false){
                                      b_end=i;
                                      f1=true;
                                  }
                         }  
                    
                         if(sign_line_imageR[j]=='O'){
                        
                                   if(f2==false){
                                       b_start=j;     
                                      f2=true;
                                  }
       
                        }
                   
                   
                   break;    
      
               }
        
               
           }
       
            
          switch(find_type){
         
             case 0x01:
                
               if((b_end-b_start)>(b2_end-b2_start)    )
                     center=(b_end+b_start)/2;
                     
               else  
                     center=(b2_end+b2_start)/2;
             break;
             
             case 0x02:
               center=(b_end+b_start)/2;
              
             break;
         }
    
    
      return center;
    
    }




int BX_camera::black_centerL(void){
         
         // find center 
         // case 1      //  |  //
         //case 2         / |  /
         
         
     char find_type=0x00;
     
     int b_end=0;
     int b_start=0;
     int b2_end=0;
     int b2_start=0;
     
     
     int center;
     int j=64;
     bool f1=false;
     bool f2=false;
     bool f3=false;
     bool f4=false;

            if(sign_line_imageL[64]==' ')
              find_type=0x02;
            else
              find_type=0x01;  
            
           
           for(int i=64;i<128; i++,j--){
               
                
               switch(find_type){
                   
                   
                   case 0x01:
                       
                         if(f1==false&&sign_line_imageL[i]==' '){ 
                                  if(f1==false){
                                      b_start=i;
                                      f1=true;
                                  }
                                  
                         }
                         if(f1== true&& f2==false&&sign_line_imageL[i]=='O'){ 
                                  if(f2==false){
                                      b_end=i-1;
                                      f2=true;
                                  }
                                  
                         }
                         
                         if(f3==false&&sign_line_imageL[j]==' '){ 
                                  if(f3==false){
                                      b2_end=j;
                                      f3=true;
                                  }
                                  
                         }
                         if(f3==true&&f4==false&&sign_line_imageL[j]=='O'){ 
                                  if(f4==false){
                                      b2_start=j-1;
                                      f4=true;
                                  }
                                  
                         }
                                    
                   break;
                   
                   
                   case 0x02:
                   
                         if(sign_line_imageL[i]=='O'){         
                    
                                  if(f1==false){
                                      b_end=i;
                                      f1=true;
                                  }
                         }  
                    
                         if(sign_line_imageL[j]=='O'){
                        
                                   if(f2==false){
                                       b_start=j;     
                                      f2=true;
                                  }
       
                        }
                   
                   
                   break;               
                   
               }
         
           }
       
            
          switch(find_type){
         
             case 0x01:
                
               if((b_end-b_start)>(b2_end-b2_start)    )
                     center=(b_end+b_start)/2;
                     
               else  
                     center=(b2_end+b2_start)/2;             
             break;
             
             case 0x02:
               center=(b_end+b_start)/2;
              
             break;
         }
 
    return center;
 
 }
 

 
 void BX_camera::read(void){
 
          w_f_vL=0x0000;
          b_f_vL=0xffff;
   
          w_f_vR=0x0000;
          b_f_vR=0xffff;
 
 
        
           
           *si=1;
           *cam_clk=1;
           
           wait_us(30);   // tune here
           *si=0;
           *cam_clk=0;
            
            
 
          line_CamR->enable();
          
          
       //input 128 //both  
          
          for(int i=0;i<128;i++){     
              *cam_clk=1;   
              wait_us(5);
             
             
             line_imageR[i]=line_CamR->read_u16();

         
         //  big small    
             if(line_imageR[i] > w_f_vR) 
                w_f_vR=line_imageR[i];
             else if(line_imageR[i] < b_f_vR )
                b_f_vR = line_imageR[i]; 
                            
             
             *cam_clk=0;
             wait_us(3);
        
           
           }
           
           
          line_CamR->disable();
          
                  
           *si=1;
           *cam_clk=1;
           
           wait_us(30);   // tune here
           *si=0;
           *cam_clk=0;
          
          
          line_CamL->enable();
           //input 128 //both  
          
          for(int i=0;i<128;i++){     
              *cam_clk=1;   
              wait_us(3);
             
             
             line_imageL[i]=line_CamL->read_u16();
         
         //  big small    
                
                
              if(line_imageL[i] > w_f_vL) 
                w_f_vL=line_imageL[i];
             else if(line_imageL[i] < b_f_vL )
                b_f_vL = line_imageL[i];   
                
             
             
             
             *cam_clk=0;
             wait_us(5);
        
           
           }
          line_CamL->disable();
           
           
           //filter L R   //may change
           
          for(int i=0;i<128;i++){   
           
           
               if( (line_imageR[i]-b_f_vR) < (w_f_vR - line_imageR[i] )    ) 
                   sign_line_imageR[i]=' ';
               else
                   sign_line_imageR[i]='O';    
           
             
               if( (line_imageL[i]-b_f_vL) < (w_f_vL - line_imageL[i] )    ) 
                   sign_line_imageL[i]=' ';
               else
                   sign_line_imageL[i]='O';    
           
           
                 
                 
                 
                 if(i==0){
                   sign_line_imageR[i]='X';
                   sign_line_imageL[i]='X'; 
                 }     
                 
           
          }
           
           
           
           }