/********************************************************************
* VT52.cpp - extends class Serial and adds new Functions
* ------------------------------------------------------
* VT52 delivers functions for the VT52 Terminal:
*   clearScreen
*   clearLine
*   setCursor
*
* Author:      Rainer Krugmann
* Date:        2011.01.23
********************************************************************/

/*

Copyright (c) 2011 Rainer Krugmann 
                   (rainer (dot) krugmann [at] gmail [dot] com)
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

*/

#include "mbed.h"
#include "VT52.h"

/********************************************************************
* class VT52 inherits from Serial
********************************************************************/
VT52::VT52(PinName tx, PinName rx) : Serial(tx, rx) {}

/********************************************************************
* Method clearScreen - set cursor home and clear screen
********************************************************************/
void VT52::clearScreen() {
    printf("\x1b\x48");                // set cursor home
    printf("\x1b\x4a");                // clear screen
}

/********************************************************************
* Method clearLine - clear line from cursor position
********************************************************************/
void VT52::clearLine() {
    printf("\x1b\x4b");
}

/********************************************************************
* Method setCursor - set cursor into column (0-79) of line (0-23)
********************************************************************/
void VT52::setCursor(unsigned char line, unsigned char column) {
    printf("\x1b\x59%c%c",(32 + line),(32 + column));
}

//*******************************************************************
