/********************************************************************
* VT52.h - extends class Serial and adds new Functions
* ----------------------------------------------------
* VT52 delivers functions for the VT52 Terminal:
*   clearScreen - set cursor home and clear screen
*   clearLine   - clear line from cursor position
*   setCursor   - set cursor into column (0-79) of line (0-23)
*
* Author:      Rainer Krugmann
* Date:        2011.01.23
********************************************************************/

/*

Copyright (c) 2011 Rainer Krugmann 
                   (rainer (dot) krugmann [at] gmail [dot] com)
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

*/

#ifndef __VT52_H__
#define __VT52_H__

namespace mbed {

/********************************************************************
* class VT52
********************************************************************/
class VT52 : public Serial {

public:
    VT52(PinName read, PinName transmit);
    void clearScreen();
    void clearLine();
    void setCursor(unsigned char line, unsigned char column);
};
}
#endif
//*******************************************************************
