/********************************************************************
* Project:     Test_VT52
* Program:     Test_VT52.cpp
* Description: Print to PC-Terminal and PC-Log
*              2 Terminal Emulations (VT52) are needed at PC
*              Serial Connection (p13, p14) is connected 
*               to RS232-USB Adapter
*  
* Author:      Rainer Krugmann
* Date:        2011.01.23
********************************************************************/

/*

Copyright (c) 2011 Rainer Krugmann 
                   (rainer (dot) krugmann [at] gmail [dot] com)
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

*/

#include "mbed.h"
#include "VT52.h"

VT52 pc(USBTX, USBRX);             // PC-Terminal 
VT52 myLog(p13, p14);              // PC-Terminal (Log)

int main() {

    unsigned char c = 0;

    myLog.baud(9600);
    myLog.clearScreen();
    myLog.printf("Hello World - Log\r\n");
    myLog.printf("=================\r\n\n");

    pc.clearScreen();
    pc.printf("Hello World!\r\n");
    pc.printf("============\r\n\n");
    
    pc.setCursor(12,3);
    pc.printf("Press any Characters ('x' to Exit): ");
    myLog.printf("Press any Characters ('x' to Exit)!\r\n");
    
    while (c != 'x')
    {
        c = pc.getc();
        myLog.printf("You pressed: %c\r\n", c); 
        pc.putc(c);
    }
    pc.setCursor(12, 9);
    pc.clearLine();
    myLog.printf("\nLine cleared after 'Press'\r\n");
    pc.setCursor(12, 9);
    
    pc.printf("nothing!");
    myLog.printf("Word 'nothing!' was printed\r\n");
    
    pc.setCursor(23, 75);
    pc.printf("End");  
    myLog.printf("\nWord 'End' was printed screen bottom\r\n");
    myLog.printf("Cursor position is at screen end (line=23 and column = 79)\r\n");
    
    myLog.printf("Program ends\r\n");
    while(1);
}
//*******************************************************************