#include "Global.h"

unsigned int 	VibroReg = 0;   //регистр состаяния вибропривода.
unsigned long	Global_Time, Time_UART,Time_Sec,Time_vibro,Time_1kHz;
float t1;
unsigned char	BuffTemp[100];
unsigned char 	Time[1000];
unsigned int 	Event1Hz;
unsigned int 	Event100Hz;
unsigned int 	Event250Hz;
unsigned int 	Event500Hz;
unsigned int 	Event1K;
unsigned int 	Event1250Hz;
unsigned int 	Event5K;
unsigned int 	Event100K;
unsigned int 	EventVibro;
unsigned int 	MODFlag=0;
unsigned int Time250Hz;
unsigned int Event250Hz;

unsigned int 	Time100K;
unsigned int 	Time1K;
unsigned int 	Time1250Hz;
unsigned int 	Time5K;
unsigned int 	Time500Hz;
unsigned int 	Time250Hz;
unsigned int 	Time1Hz;
unsigned int 	Time100Hz;
unsigned int 	Clock1Hz;
unsigned int    ShiftD;
unsigned int    ShiftL;





 int BuffADC_1Point			[600];
 int BuffADC_1Point_64  	[100];
 int BuffADC_1Point_Recalc	[100];
 
 int BuffADC_128Point		[100];	
 int BuffADC_64Point		[100];
 
 int BuffPLC_FILT    		[20];
 unsigned int C_PLC_F=0;
 
 int BuffADC_32Point		[100];
 int BuffADC_16Point		[100];
 
 int BuffADC_10HFO			[100];
 int BuffADC_10v		   	[100];
 
 int BuffADC_10v_OLD	   	[100];
 int BuffADC_10v_F		   	[100];
 int BuffADC_znak			[100];

int Buff_Restored_Mod 			[100];
int Buff_PLC_Eror	 			[100];
int BSinMns	 			[100];
int BSinPls	 			[100];
int ADC_1Point			=0;
int ADC_32PointD		=0;

int ADC_128Point	=0;
int ADC_64Point		=0;
int ADC_32Point		=0;
int ADC_16Point		=0;
//unsigned int    EventMod;


__asm void boot_jump( uint32_t address ){
   LDR SP, [R0]         ;Load new stack pointer address
   LDR R0, [R0, #4]     ;Load new program counter address
   BX R0
}

void Param_init(void)
{
    int temp=0;
    
    InitMOD();
     for(int q=0; q<20; q++)
   			{
   		    	BuffPLC_FILT  [q] = 0;
   			}
Gyro.CuruAngleLog=0;
	Global_Time	= 0;
    Time_UART	= 0;
    Time_Sec	= 0;
    Time_vibro	= 0;
    Time1250Hz  = 0;
    Time_1kHz   = 0;
    Event1Hz 	= 0;
    Event1K 	= 0;
    Event100K 	= 0;
    EventVibro 	= 0;
    Time1K 		= 0;
    Time100K	= 0;
    Time1Hz		= 0;
    Clock1Hz	= 0;
    ShiftD		= 0;
    ShiftL		= 0;
    Event500Hz  = 0;
    Time500Hz   = 0;
  
    Temp_AMP64P		= 0;

    Gyro.Log    	= 0;
    Gyro.LogPLC		= 0;
    Gyro.PLC_Lern 	= 0;
    Gyro.CuruAngle  = 0;
    Pulse_8Point 	= 0;
    Pulse_16Point 	= 0;
    Pulse_16PointD	= 0;
    Pulse_32Point 	= 0;
    Gyro.FlashMod	= 0;
   
   
/////////////////////////////////////////////
///////////инициализация таймеров////////////
/////////////////////////////////////////////
Init_TIM1(TIME_INTERVAL ); //Timer 1: CCLK / 7812 = 12800.819Hz; Vibro: Timer1/32 = 400.025Hz; 10ms???
Init_TIM2();				//Timer 2: CCLK / 4 / 250 = 100kHz
/////////////////////////////////////////////
    /////////////инициализация переменных в структ вибро/////////////////
    
    Gyro.DropDelayGLD = DropDelayGLD_0;//задержка на выдачу 45 микросекунд для любого адреса ГЛД
    Gyro.PLC_Error2Mode		= 1400;
    Gyro.SOC_Out    		= 0xDD;
   
    Gyro.RgConMod 			= 1;
    
    GyroP.Str.ParamMod=0;
    
  ReadFlash ();
   //  GyroP.Str.ParamMod=0;
    if(GyroP.Str.ParamMod==1)
    {			
    Gyro.ShowMod2=0;
     			Gyro.TimeToJump			= GyroP.Str.TimeToJump;     											
     			Gyro.JumpDelta			= GyroP.Str.JumpDelta;   
                Gyro.ShiftMod			= GyroP.Str.ShiftMod;
    			Gyro.PLC_Start   		= 0x7fff+GyroP.Str.PLC_Start;
      		    Gyro.DownTreshold		= (unsigned int)((GyroP.Str.DownTreshold-0x7fff)&0xffff);															//27
				Gyro.HighTreshold		= (unsigned int)((GyroP.Str.HighTreshold-0x7fff)&0xffff);
			    Gyro.PLCDelay			= GyroP.Str.PLCDelay;  	
				Gyro.ResetLevelCool		= (unsigned int)((GyroP.Str.ResetLevelCool-0x7fff)&0xffff);															//105
                Gyro.ResetLevelHeat		= (unsigned int)((GyroP.Str.ResetLevelHeat-0x7fff)&0xffff);
                Gyro.HFO_Gain			= GyroP.Str.HFO_Gain;
    			Gyro.HFO_ref			= (unsigned int)(GyroP.Str.HFO_ref);
                Gyro.LG_Type			= GyroP.Str.LG_Type;
                Gyro.LG_Type = 1;
                Gyro.My_Addres			= GyroP.Str.My_Addres; 								 //  Gyro.My_Addres			= 0; 
   				Gyro.GLD_Serial 		= GyroP.Str.GLD_Serial;	        
    	    	Gyro.FrqHZ				= (7680000/GyroP.Str.FrqHZ);
    			Gyro.Frq 				= ((7680000/GyroP.Str.FrqHZ)<<16);
    			Gyro.FrqHZmin 			= ((7680000/GyroP.Str.FrqHZmin)<<16);
    			Gyro.FrqHZmax			= ((7680000/GyroP.Str.FrqHZmax)<<16);
    			Gyro.FrqChengSpeed		= GyroP.Str.FrqChengSpeed;
                Gyro.PLC_Gain			= GyroP.Str.PLC_Gain;
                Gyro.PLC_Phase          = GyroP.Str.PLC_Phase;
    			Gyro.ModAmp				= GyroP.Str.ModAmp;
                Gyro.FrqPhase			= GyroP.Str.FrqPhase;
    			Gyro.AmpPer				= 700;//GyroP.Str.AmpPer*100;
    			Gyro.Amp    			=(GyroP.Str.AmpPer<<17);
    		    Gyro.AmpSpeed 			= GyroP.Str.AmpSpeed;
    			Gyro.AmpPerDel			= GyroP.Str.AmpPerDel;
    			temp=((GyroP.Str.VB_Fdf_Hi<<16) | GyroP.Str.VB_Fdf_Lo);
    			temp=temp*20;
    			Gyro.AmpTarget=(unsigned int)(temp);
    			Gyro.AmpPerMin 			= GyroP.Str.AmpPerMin;
    			Gyro.AmpPerMax 			= GyroP.Str.AmpPerMax;
    			Gyro.AmpMin 			= GyroP.Str.AmpMin;
    			Gyro.AmpTD  			= GyroP.Str.AmpTD;
    		    F_vib=(103200000<<5)/((Gyro.Frq)>>10);//периуд вибро.
                T_vibP = F_vib/10000;
                T_vib_1 = Gyro.AmpPer * T_vibP;
        	 	T_vib_2 = T_vibP * (10000-Gyro.AmpPer);
        LPC_MCPWM->LIM1 = F_vib;
        LPC_MCPWM->LIM2 = F_vib;
        LPC_MCPWM->MAT1 =  T_vib_1;
        LPC_MCPWM->MAT2 =  T_vib_2;
                if(Gyro.LG_Type==1){ 
               //Gyro.HFO_Max=((int)(GyroP.Str.DAC_current_Work*0.67)-2000);
                 Gyro.HFO_Max=0xffff-GyroP.Str.DAC_current_Work;
                 
               //Gyro.HFO_Min=((int)(GyroP.Str.DAC_current_Start*0.67)-2000);
                 Gyro.HFO_Min= 0xffff-GyroP.Str.DAC_current_Start; 
                } 
                else 			    Spi.DAC_A = ((((int)(GyroP.Str.DAC_current_Work+0x7fff)  & 0xffff)+22544)*0.65);	
                Gyro.DacIn				= GyroP.Str.DAC_current_Work;
    	//		Gyro.TermoNKU			= GyroP.Str.TermoNKU<<2;
                Gyro.Firmware_Version	= 0x11;
    		//	Spi.DAC_A				= GyroP.Str.DAC_A;
    	   	//	Spi.DAC_B 				= GyroP.Str.DAC_B;
    			Gyro.Gain_Sin 			= GyroP.Str.Gain_Sin;
    			Gyro.Gain_Cos 			= GyroP.Str.Gain_Cos;
    			Out_G_photo(Gyro.Gain_Sin, Gyro.Gain_Cos); 	
   }
    else
    {
    Gyro.DownTreshold		= GyroP.Str.DownTreshold;  																//27
	Gyro.HighTreshold		= GyroP.Str.HighTreshold;  	
	Gyro.PLCDelay			= 5000;  	
	Gyro.ResetLevelCool		= 56000; 																//105
    Gyro.ResetLevelHeat		= 15000;
    Gyro.HFO_ref			= 13000;
    Gyro.LG_Type			= 0;
    Gyro.PLC_Phase			= 3;
    Gyro.PLC_Gain			= 3;
    Gyro.FrqPhase         	= 8;
    Gyro.FrqHZ				= 403;
    Gyro.Frq 				= Gyro.FrqHZ<<16;
    Gyro.FrqHZmin 			= 350<<16;
    Gyro.FrqHZmax			= 450<<16;
    Gyro.FrqChengSpeed		= 100;
    Gyro.ModAmp				= 250;
    Gyro.AmpPer				= 20;
    Gyro.AmpPerMin 			= 2;
    Gyro.AmpPerMax 			= 90;
    Gyro.AmpSpeed 			= 1;
    Gyro.AmpPerDel			= 3;
    Gyro.AmpTarget  		= 5500;// целевая амплитуда ВП
    Gyro.Amp    			= 20*65535;
    Gyro.AmpMin 			= 20;// минимальное  значение AmpT;5
    Gyro.AmpTD  			= 20;////////////////////////////////////////////////////////
    Gyro.TermoNKU			= 44700;//48824*0,0061-273=25 С°
    Spi.DAC_B 				= Gyro.PLC_Start;
    Gyro.PLC_Error2Mode		= 1400; //для записи мод  
    Gyro.Gain_Sin 			= 175;
    Gyro.Gain_Cos 			= 215; 
    Gyro.Firmware_Version	= 0x11; //версия программы
    Gyro.GLD_Serial 		= 123; //серийный номер
    Gyro.My_Addres			= 0; //адрес глд
    Gyro.Tmp_OffsetT4       = 0;
    Gyro.Tmp_OffsetT5       = 0;
    Gyro.Tmp_scaleT4  		= 1;								//53      	 				
    Gyro.Tmp_scaleT5        = 1;
    
    Gyro.DAC_current_Work	=50000;							//3
	Gyro.DAC_current_Start	=41000;      


		    F_vib=(103200000<<5)/((Gyro.Frq)>>10);//периуд вибро.
                T_vibP = F_vib/10000;
                T_vib_1 = Gyro.AmpPer * T_vibP;
        	 	T_vib_2 = T_vibP * (10000-Gyro.AmpPer);
        LPC_MCPWM->LIM1 = F_vib;
        LPC_MCPWM->LIM2 = F_vib;
        LPC_MCPWM->MAT1 =   T_vib_1;
        LPC_MCPWM->MAT2 =  T_vib_2;
    }
  	Spi.DAC_B=Gyro.PLC_Start;
    switch(Gyro.My_Addres){//смещение поджига и подсветки в зависимости от адреса ГЛД
    case 0:
    Gyro.Discharg  = StartDischarg  << ShiftStart0;
    Gyro.BackLight = StartBackLight << ShiftStart0;
    break;
    case 1:
    Gyro.Discharg  = StartDischarg  << ShiftStart1;
    Gyro.BackLight = StartBackLight << ShiftStart1;
    break;
    case 2:
    Gyro.Discharg  = StartDischarg  << ShiftStart2;
    Gyro.BackLight = StartBackLight << ShiftStart2;
    break;
    case 3:
    Gyro.Discharg  = StartDischarg  << ShiftStart3;
    Gyro.BackLight = StartBackLight << ShiftStart3;
    break;
    }
    
    /////////////////////////////////////////////////////
    //////инициализация цап_LPC (р0.26 цап выход)////////
    /////////////////////////////////////////////////////
    LPC_PINCON->PINSEL1 = 0x00200000;
    /////////////////////////////////////////////////////
    ////////////начальное значение для цап///////////////
    //////////////////середина шкалы/////////////////////
    /////////////////////////////////////////////////////

    ////////////////////////////////////////////////////
    /////////////поправочный коэффициент/////////////////
    /////////для цапов (граници +-12.5 вольт)////////////
    /////////////////////////////////////////////////////
    K_DAC=65535.0/(65535.0+(deltaDAC+deltaDAC/2));
    K_DAC=0.8;

    /////////////////////////////////////////////////////
    /////////////обнуление переменых для/////////////////
    ///////////////переменных энкодера///////////////////
    /////////////////////////////////////////////////////
    secPuls =0;// переменная для конопки поджига аск глд(временная)
    Gyro.CaunPlus	=0;
    Gyro.CaunMin	=0;
    Cur_QEI=0;
    Last_QEI=0;
}
void BUTTON_init(void) {
  LPC_GPIO0->FIODIR      &= ~(1 << 1);    /* PORT2.10 defined as input       */
  LPC_GPIOINT->IO0IntEnF |=  (1 << 1);    /* enable falling edge irq         */

  NVIC_EnableIRQ(EINT3_IRQn);              /* enable irq in nvic              */
}
/*void EINT3_IRQHandler()
{
  if(Gyro.EXT_Latch)Gyro.EXT_Latch=0;
  else Gyro.EXT_Latch=1;
  LPC_GPIOINT->IO2IntClr |= (1 << 10);    
}*/
void GLD_Init(void)
{    
				int Dummy; // инициализация мусорки для очистки буфера приема.
     BUTTON_init();      

    if(Gyro.LG_Type==1)Spi.DAC_A=Gyro.HFO_Max;



    /////////////////////////////////////////////////////
    /////////////инициализация энкодера//////////////////
    /////////////////////////////////////////////////////
    
    LPC_SC->PCONP |= (1<<18);//0x00040000;		включение квадратурного энкодера.
    LPC_SC->PCLKSEL1 |= 0x00000001;	   // выбор частоты для кв.э. CLK=103MHz
    LPC_PINCON->PINSEL3 &= ~0x4100;
    LPC_PINCON->PINSEL3 |= 0x4100;	  //P1.20, p1.23 установить как входы кв.э
    LPC_PINCON->PINMODE3 |= 0x3C300;	  //P1.20, p1.23 

    //Gyro.ShiftMod=150;
    LPC_QEI->MAXPOS = MAX_QEI_CNT;	//LPC_QEI->"регистор максимального положения" = 2147483646
    LPC_QEI->FILTER = 2;		    // фильтр( ?? )
    LPC_QEI->CON = 0xF;				//сбросить в ноль все счетчики кв.э. (скорость, направление, позицию и тд)
    LPC_QEI->CONF = (1<<2) |(0<<1);	//Quadrature inputs, no inverting,only A pulses are counted

    LPC_QEI->CLR = 0x1fff; 			 //r. сбросить все прерывания
    LPC_QEI->IEC = 0x1fff;			 //r. запретить прерывание при изменении направления

  /*NVIC_SetPriority(QEI_IRQn, 0);
  NVIC_EnableIRQ(QEI_IRQn);*/
    //////////////////////////////////////////////////////
    //////////////////////////////////////////////////////


  //////////////////////////////////////////////////////
  ///////////////////////I2C////////////////////////////
  //////////////////////////////////////////////////////

  LPC_SC->PCONP |= (1 << 19);//включение интерфейса I2C.

  /* set PIO0.27 and PIO0.28 to I2C0 SDA and SCK */
  /* function to 01 on both SDA and SCK. */
  LPC_PINCON->PINSEL1 &= ~0x03C00000; //P0.27 - SDA.
  LPC_PINCON->PINSEL1 |= 0x01400000;	//P0.28 - SCK.

	//                   подтверждение     Флаг           флаг        разрешения 
  /*сброс флагоф          флага    прерывания I2C      старта      интерфейса I2C    */
  LPC_I2C0->CONCLR = I2CONCLR_AAC | I2CONCLR_SIC | I2CONCLR_STAC | I2CONCLR_I2ENC;   // установка микроконтроллера в режим мастера 

  /*--- Reset registers ---*/
  LPC_I2C0->SCLL   = I2SCLL_SCLL; // - счетчик scl low time period
  LPC_I2C0->SCLH   = I2SCLH_SCLH; // - счетчик scl high time period
  
   	I2CMasterBuffer[0] = A_ADDRESS;  
	I2CMasterBuffer[1] = WRITE_CMD;  
	I2CMasterBuffer[3] = B_ADDRESS;  
	I2CMasterBuffer[4] = WRITE_CMD;  
  
  LPC_I2C0->CONSET = I2CONSET_I2EN; //включение интерфейса I2C.
  //////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////






    ///////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////
    //////////////////////////SPI//////////////////////////
    ///////////////////////////////////////////////////////
   Dummy = Dummy;

  /* Enable AHB clock to the SSP0, SSP1 */
 	 LPC_SC->PCONP |= (0x1<<21); // включение SSP0.

  /* выбор частоты для переферии используем по умолчания с делителем основной на 4 */
   LPC_SC->PCLKSEL1 &= ~(0x3<<10);	//00 CLK/4;	1 CLK; 2 CLK/2; 3 CLK/8
   LPC_SC->PCLKSEL1 |= (0x0<<10);	//00 CLK/4;	1 CLK; 2 CLK/2; 3 CLK/

  // P0.15~0.18 as SSP0 
  LPC_PINCON->PINSEL0 &= ~(0x3UL<<30);  //установит Р 0.15 
  LPC_PINCON->PINSEL0 |=  (0x2UL<<30);  //частота для синхронизациии Master - slave

  LPC_PINCON->PINSEL1 &= ~((0x3<<0)|(0x3<<2)|(0x3<<4)); // устанивоить   Р 0.17    и   Р 0.18
  LPC_PINCON->PINSEL1 |=  ((0x2<<2)|(0x2<<4));	        //    как         MISO0    и    MOSI0

  LPC_PINCON->PINMODE0 &= ~(0x3UL<<30);// ?  установление на Р 0.15 режима On-Chip pull-down resistor enabled
  LPC_PINCON->PINMODE0 |=  (0x3UL<<30);// ?  установление на Р 0.15 режима On-Chip pull-down resistor enabled

  LPC_PINCON->PINMODE1 &= ~((0x3<<2)|(0x3<<4));// ?  установление на Р 0.17 и Р 0.18 режима On-Chip pull-down resistor enabled
  LPC_PINCON->PINMODE1 |=  ((0x3<<2)|(0x3<<4));// ?  установление на Р 0.17 и Р 0.18 режима On-Chip pull-down resistor enabled

  LPC_SSP0->CR0 = ((3<<8)|(0<<7)|(0<<4) |0xF); // (0xF)-установление DSS(Data sise select) в 16-битный формат, (3<<8 scr - выбор частоты), 
                                             	//   низкий уровень линии тактирования между кадрами, прикрепление передачи к первому нарастанию тактового мигнала
																						 //    формат кадра TI.
   
  /* SSPCPSR clock prescale register, master mode, minimum divisor is 0x02 */
  LPC_SSP0->CPSR = 0x2;	  // freq = CLK/(cpsdvr*(scr+1)) = 1.6 MHz
 
 /*SSP enable, master mode	   */
  LPC_SSP0->CR1 = SSPCR1_SSE;	
//  LPC_SSP1->CR1 = SSPCR1_SSE;
   while (LPC_SSP0->SR & SSP_BUSY);
   while (LPC_SSP0->SR & RX_SSP_notEMPT)  /* clear the RxFIFO */
	Dummy = LPC_SSP0->DR;		
  //all pins after reset is in GPIO mode, so CS pins needn't to configure
     LPC_GPIO0->FIODIR |= (1<<16);		// P0.16 defined as CS for ADC
	 LPC_GPIO0->FIOSET |= (1<<16);		// set CS for ADC

	LPC_GPIO0->FIODIR |= (1<<23);		// P defined as CS for DAC
	LPC_GPIO0->FIOCLR |= (1<<23);		// set CS for DAC 
    while (LPC_SSP1->SR & RX_SSP_notEMPT)
	Dummy = LPC_SSP1->DR;	/* clear the RxFIFO */
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////




    /////////////////////////////////////////////////////
    /////////////////инициализация ног///////////////////
    /////////////////////////////////////////////////////
    
    /////////////////////////////////////////////////////
    Gyro.PinRegOld  = 0xffffffff;
    Gyro.PinReg     = 0;        // всЁ выключенно
    PinCheng();
    /////////////////////////////////////////////////////
Gyro.ModeOut=0; 
    /////////////////////////////////////////////////////
    //////////////отладочный светодиод///////////////////
    /////////////////////////////////////////////////////
    
    LPC_PINCON->PINSEL0  &= ~(0x00<<28);
    LPC_PINCON->PINSEL0  |=  (0x00<<28);   
    LPC_PINCON->PINMODE0 |=  (0x3<<28);
    LPC_GPIO1->FIODIR    |=  (1<<30);
    /////////////////////////////////////////////////////
    /////////////////////////////////////////////////////
    NVIC_EnableIRQ(EINT3_IRQn);
    LPC_GPIOINT->IO0IntEnR |=  (1<<1);    /* enable rasing edge irq         */
    /////////////////////////////////////////////////////
    ////////////////управление уартом////////////////////
    /////////////////////////////////////////////////////
    LPC_GPIO2->FIODIR   |= (1<<7);//направление ноги uart enable
    /////////////////////////////////////////////////////
    /////////////////////////////////////////////////////



    /////////////////////////////////////////////////////
    ///////////////////////поджиг////////////////////////
    /////////////////////////////////////////////////////
    LPC_PINCON->PINSEL0  &= ~(3<<8);       //e. P0.4 is GPIO pin (запись ( 00 ) в 9:8 бит PISEL0    выбор P0.4 как GPIO)
    LPC_PINCON->PINMODE0 |=  (3<<8);       //e. P0.4 is GPIO pin (запись ( 11 ) в 9:8 бит PINMODE0  "для включения подтягивающего резистора")
    LPC_GPIO0->FIODIR    |=  (1<<4);      //e. P0.4 is output   (запись ( 1 ) в  5  бит FIODIR    выбор P0.4 как выход)
    /////////////////////////////////////////////////////
    /////////////////////////////////////////////////////



    /////////////////////////////////////////////////////
    /////////////////////вибро 1/////////////////////////
    /////////////////////////////////////////////////////
    LPC_PINCON->PINSEL3  &= ~(0x00<<18);       //e. P1.25 is GPIO pin
    LPC_PINCON->PINSEL3  |= (0x00<<18);       //e. P1.25 is GPIO pin
    LPC_PINCON->PINMODE3 |= (3<<18);      //e. P1.25  (включениe подтягивающего резистора")
    LPC_GPIO1->FIODIR    |= (1<<25);        //e. P0.5 is output   (запись ( 1 ) в  5  бит FIODIR    выбор P0.5 как выход)
    LPC_GPIO1->FIOCLR    |= (1<<25);
    //////////////////////////////////////////////////////
    //////////////////////вибро 2/////////////////////////
    //////////////////////////////////////////////////////
    LPC_PINCON->PINSEL3   &= ~(0x00<<24);       //e. P1.28 is GPIO pin
    LPC_PINCON->PINSEL3   |= (0x00<<24);       //e. P1.28 is GPIO pin
    LPC_PINCON->PINMODE3 |= (3<<24);      //e. P1.28 is GPIO pin (запись ( 11 ) в бит PINMODE0  "для включения подтягивающего резистора")
    LPC_GPIO1->FIODIR    |= (1<<28);        //e. P1.28 is output   (запись ( 1 ) в  5  бит FIODIR    выбор P0.5 как выход)
    LPC_GPIO1->FIOCLR    |= (1<<28);
    /////////////////////////////////////////////////////
    /////////////////////////////////////////////////////



    /////////////////////////////////////////////////////
    /////////////инициализация подсветки/////////////////
    /////////////////////////////////////////////////////
    LPC_PINCON->PINSEL2   &= ~(0x00<<24); 
    LPC_PINCON->PINSEL2   |= (0x00<<24);     //e. P2.12 is GPIO pin
    LPC_PINCON->PINMODE3 |= (3<<24);      //e. P1.28 is GPIO pin (запись ( 11 ) в бит PINMODE0  "для включения подтягивающего резистора")
    LPC_GPIO2->FIODIR    |= (1<<12);        //e. P1.28 is output   (запись ( 1 ) в  5  бит FIODIR    выбор P0.5 как выход)
    LPC_GPIO2->FIOCLR    |= (1<<12);
    ///////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////


    ///////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////
    ///////////////////включение таймеров//////////////////
    ///////////////////////////////////////////////////////    
    enable_timer1();
    enable_timer2();
    ///////////////////////////////////////////////////////
    
    //////////////////////////////////////////////////////////////////
    // LPC_GPIO0->FIOCLR = (1<<5);/////////////отключение поджига
    
    

    ///////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////
    //////////////////////////SPI//////////////////////////
    ///////////////////////////////////////////////////////
   Dummy = Dummy;

  /* Enable AHB clock to the SSP0, SSP1 */
 	 LPC_SC->PCONP |= (0x1<<21); // включение SSP0.

  /* выбор частоты для переферии используем по умолчания с делителем основной на 4 */
   LPC_SC->PCLKSEL1 &= ~(0x3<<10);	//00 CLK/4;	1 CLK; 2 CLK/2; 3 CLK/8
   LPC_SC->PCLKSEL1 |= (0x0<<10);	//00 CLK/4;	1 CLK; 2 CLK/2; 3 CLK/

  // P0.15~0.18 as SSP0 
  LPC_PINCON->PINSEL0 &= ~(0x3UL<<30);  //установит Р 0.15 
  LPC_PINCON->PINSEL0 |=  (0x2UL<<30);  //частота для синхронизациии Master - slave

  LPC_PINCON->PINSEL1 &= ~((0x3<<0)|(0x3<<2)|(0x3<<4)); // устанивоить   Р 0.17    и   Р 0.18
  LPC_PINCON->PINSEL1 |=  ((0x2<<2)|(0x2<<4));	        //    как         MISO0    и    MOSI0

  LPC_PINCON->PINMODE0 &= ~(0x3UL<<30);// ?  установление на Р 0.15 режима On-Chip pull-down resistor enabled
  LPC_PINCON->PINMODE0 |=  (0x3UL<<30);// ?  установление на Р 0.15 режима On-Chip pull-down resistor enabled

  LPC_PINCON->PINMODE1 &= ~((0x3<<2)|(0x3<<4));// ?  установление на Р 0.17 и Р 0.18 режима On-Chip pull-down resistor enabled
  LPC_PINCON->PINMODE1 |=  ((0x3<<2)|(0x3<<4));// ?  установление на Р 0.17 и Р 0.18 режима On-Chip pull-down resistor enabled

  LPC_SSP0->CR0 = ((3<<8)|(0<<7)|(0<<4) |0xF); // (0xF)-установление DSS(Data sise select) в 16-битный формат, (3<<8 scr - выбор частоты), 
                                             	//   низкий уровень линии тактирования между кадрами, прикрепление передачи к первому нарастанию тактового мигнала
																						 //    формат кадра TI.
   
  /* SSPCPSR clock prescale register, master mode, minimum divisor is 0x02 */
  LPC_SSP0->CPSR = 0x2;	  // freq = CLK/(cpsdvr*(scr+1)) = 1.6 MHz
 
 /*SSP enable, master mode	   */
  LPC_SSP0->CR1 = SSPCR1_SSE;	
//  LPC_SSP1->CR1 = SSPCR1_SSE;
  while (LPC_SSP0->SR & SSP_BUSY);
  while (LPC_SSP0->SR & RX_SSP_notEMPT)  /* clear the RxFIFO */
	Dummy = LPC_SSP0->DR;		
  //all pins after reset is in GPIO mode, so CS pins needn't to configure
     LPC_GPIO0->FIODIR |= (1<<16);		// P0.16 defined as CS for ADC
	 LPC_GPIO0->FIOSET |= (1<<16);		// set CS for ADC

	LPC_GPIO0->FIODIR |= (1<<23);		// P defined as CS for DAC
	LPC_GPIO0->FIOCLR |= (1<<23);		// set CS for DAC 
    while (LPC_SSP1->SR & RX_SSP_notEMPT)
	Dummy = LPC_SSP1->DR;	/* clear the RxFIFO */
//Gyro=GyroP.str;
//Gyro = (*(struct Gyro*)(&GyroP.Str));

}





