#ifndef VIBRO_H
#define VIBRO_H

#define ClrV1  LPC_GPIO1->FIOSET=(1<<25);
#define SetV1  LPC_GPIO1->FIOCLR = (1<<25);

#define TXOn  LPC_GPIO2->FIOSET=(1<<7);
#define TXOff LPC_GPIO2->FIOCLR = (1<<7);

#define  ClrV2 LPC_GPIO1->FIOSET = (1<<28);
#define  SetV2 LPC_GPIO1->FIOCLR = (1<<28);

#define  LoopOn  LPC_GPIO1->FIOSET  = (1<<30);
#define  LoopOff LPC_GPIO1->FIOCLR  = (1<<30);
#define  StartV1  0
#define  StartV2 15
#define  TIME_INTERVAL	(7812)

 
#define  Rate1       0x01    
#define  Rate2       0x02  
#define  Rate3       0x3 
#define  Rate7       0x7

#define  PRate1      0x81
#define  PRate2      0x82
#define  PRate3      0x83 
#define  PRate7      0x87  
#define  PRate5K	 0x94
#define  Rate5K  	 0x14
 
////////////////////////////////////////////////////////
////Дефайны для декодирования запроса параметров Rate///
////////////////////////////////////////////////////////
   #define   Delta_500   0x20
   #define   Delta_EXT   0x0
   
   #define  Delta_PS_INT   0x80
   #define  Delta_PS_EXT   0x0
   
   
   
   #define  PDelta_500   0x90
   #define  PDelta_EXT   0x10
   
   
   #define   Delta_Bins  0x0
   #define  PDelta_Bins  0x1
   
   
   #define  PB_Delta_EXT 0x9
   #define   B_Delta_EXT 0x1
   #define  PB_Delta_INT 0x8
   #define   B_Delta_INT 0x0
///////////////////////////////////////////////////////////   
  
#define FrqOFF  Gyro.RgConA &= ~AFRQ;   //установить контур регулировки частоты в "0"
#define FrqON   Gyro.RgConA |=  AFRQ;   //установить контур регулировки частоты в "1"

  
#define AVibOFF  Gyro.RgConA &= ~AVBT;   //установить контур регулировки частоты в "0"
#define AVibON   Gyro.RgConA |=  AVBT;   //установить контур регулировки частоты в "1"

#define HFOOFF  Gyro.RgConA &= ~AHFO;  //установить контур накачки в "0"
#define HFOON   Gyro.RgConA |= AHFO;   //установить контур накачки в "1"

#define PlcOFF  Gyro.RgConA &= ~APLC;  //установить контур регулировки периметра в "0"
#define PlcON   Gyro.RgConA |= APLC;   //установить контур регулировки периметра в "1"
  
#define  AFRQ 	(1<<6)
#define  AVBT   (1<<5)
#define  MPLC  	(1<<4)  
#define  APLC  	(1<<3)  
#define  AHFO  	(1<<1)

    
#define LedOFF  Gyro.PinReg &= ~PinRegBitLED; //установить бит светодиода в "0"
#define LedON   Gyro.PinReg |= PinRegBitLED;   //установить бит светодиода в "1"

#define  StartBackLight       0xf
#define  StartDischarg        0xc

#define  PinRegBitTXE  	(1<<5)
#define  PinRegBitLED  	(1<<4)
#define  PinRegBitD  	(1<<3)
#define  PinRegBitL  	(1<<2)
#define  PinRegBit_2V  	(1<<1)
#define  PinRegBit_1V  	(1<<0)

#define  ShiftStart0       0x0
#define  ShiftStart1       0x1
#define  ShiftStart2       0x2
#define  ShiftStart3       0x3

#define DropDelayGLD_0 100
#define DropDelayGLD_1 100
#define DropDelayGLD_2 100
#define DropDelayGLD_3 100


extern int tempAMP;

//int	        qei;
//int           QEIznak1,QEIznak2;
//unsigned int	StrayHZ; //помеха
//unsigned int	StrayHZ_flag;
//int			flag;
//unsigned int	StrayPLC_Pls; //помеха +
//int 			StrayPLC_Mns; //помеха -
//unsigned int 	StrayPLC_2Mode;
//unsigned int	StrayPLC_flag;
//unsigned int	ModJump;
//unsigned int	TimJump;
//unsigned int 	flagGph_W;
//unsigned int 	Test_time;
//unsigned int 	Test_time1;
//unsigned int Rate1_Flag;  
//unsigned int Rate2_Flag;
//int AmpSC;//переменная для других ошумлений
//unsigned int Delta500_Event;
//unsigned int Delta_Bins_Event500;
//unsigned int B_Delta_Event500;
//float Ktermo;
//unsigned int EventMOD;	
//контур регулеровки Периметра    "PLC" - без модулятора
//int PLC_Delta; 						// разница между старым и новым показаниями
//int PLC_DeltaADD; 					// разница между старым и новым показаниями с учетом знака управляешего напряжения АЦП
//int PLC_Old;
//int PLC_ADC_DOld; 	
//int PlC_MaxD;                       // разница между максимальной и текущей амплитудами.
//int PLC_Regul;
//int Num;
//int StopCuruAngle;
//unsigned int DeltaEXT_Event;  // вывод параметров типа Rate по внешней защелке.
//unsigned int B_Delta_EventEXT;// вывод параметров типа Rate по внешней защелке.(надо чтоб от одного влага было, как Event_500Hz)

typedef struct _Gyro {
	   
	   
		   unsigned int TimeToJump;  	                     						            	//5
		   unsigned int JumpDelta; 
		   
		   unsigned int ShowMod2;
		   int Debag; 
		   int Debag2; 
		   unsigned int UARTFlag; 
		   unsigned int PLC_Start; 
		   unsigned int LG_Type; 
		   unsigned int	LogPLC;														// 1
		   unsigned int	Log;
		   unsigned int	LogMod;														// 2
		   unsigned int PLC_Phase;
		   int PLC_Gain;	
		   unsigned int	PLC_Lern; 													// 3 обратный таймер для поиска максимальной амплитуды при работе без модулятора
		   int	PLC_Eror; 
		   int	PLC_Eror_Rate; 	
		   int	PLC_Eror_count;
		   int  PLC_regul;
		   unsigned int ModAmp;   													// 4 амплитуда модулятора
		   unsigned int ShiftMod;   
		   
		   unsigned int FlashMod; 													// 5 0-ничего не делать, 1 - запись во Flash, 2 чтение из Flash.
		   unsigned int ModeOut;													// 6 переменная для выбора варианта вывода параметров типа Rate.
		  
		   unsigned int Rate1_Event;	   												// 7 событие 1с для вывода параметров Rate 1
		   unsigned int Rate3_Event;
		   unsigned int Reper_Event;												// 8 событие для вывода набора параметров типа Rate по меандру.
		   unsigned int Event_500Hz;
		   unsigned int EvenRate7;
		   unsigned int EvenRate5K;
		
		   int DAC_current_Work;											//3
	       int DAC_current_Start;                         					//4 стартовый ток накачки?
		   int HFO_ref; 
		   int HFO_Min;
		   int HFO_Max;
		   unsigned int HFO_Gain;
		   unsigned int RgConA;														// 9 регистр управления ГЛД
		   unsigned int RgConB;														//10 регистр управления ГЛД
		   unsigned int RgConMod;
	
		   unsigned int Gain_Sin;													//11 коиф усиления синуса.
		   unsigned int Gain_Cos;													//12 коиф усиления косинуса.
		   unsigned int FrqPhase;
		   unsigned int FrqPhaseEror;
		   unsigned int Frq;      													//13 Непосредственное значение частоты для таймера.
		   unsigned int FrqHZ;     													//14 Частота в Гц.
		   unsigned int FrqHZmin;													//15 Мин значение частоты ВП
		   unsigned int FrqHZmax;  													//16 Мах  значение частоты ВП
		   unsigned int FrqChengSpeed;												//17 скорость регулировки  частоты ВП
		   unsigned int L_vibro;	
		   
		   unsigned int VibroFrqRegulF;												//18 флаг регулировки частоты ВП
		   unsigned int VibroAMPRegulF;												//19 флаг регулировки амплитуды ВП
		   unsigned int VibroNoiseF;												//20 флаг ошумления амплитуды ВП
		   unsigned int VibroOutF;  												//21 флаг изменения состояния ножек вибро.
		   unsigned int LowVibroFlag;
		   unsigned int ClrVFlag; 
		    
		   unsigned int Amp;														//22 значение амплитуды вибропривода в попугаях (Gyro.Amp = (0%--100%) << 16)
		   unsigned int AmpPer;														//23 Амплитуда в процентах Gyro.AmpPer = Gyro.Amp>>16	;
		   unsigned int AmpT;     													//24 значение тиков после которых происходит смена амплитуды ошумления ( rand() % Gyro.AmpTD+Gyro.AmpMin)(частота ошумления)
		   unsigned int AmpMin;														//25 минимальное  значение AmpT(частота ошумления);
		   unsigned int AmpTD;														//26 диапозон частоты ошумления(частота ошумления);
		  
		   unsigned int AmpPerMin; 													//27 ограничение минимальной  амплитуды ВП
		   unsigned int AmpPerMax; 													//28 ограничение максимальной амплитуды ВП
		   unsigned int AmpSpeed;  													//29 коиффициент сорости регулировки амплитуды
		   unsigned int AmpTarget; 													//30 целевая амплитуда ВП к которой стремится регулировка.
		   unsigned int AmpPerDel;													//31 значение для расчета амплитуды (дельта амплитуды) на сколько будет отличаться в працентах 1 амплитуда от второй при ошумлении, мин знач : AmpPer, мах знач : AmpPer+AmpPerDel; (в процентах)
		   unsigned int AmpN1;    													//32 левая граница импулься ВП
		   unsigned int AmpN2;    													//33 правая граница импулься ВП
		   unsigned int F_ras;														//34 частота расщипления 
		   unsigned int F_rasAdd;		 	     
		   int		    MaxAmp;            										    //35 амплитуда Пик-Пик расчтитанная по востановленному синусу. 
		
		//ЭНКОДЕР
		   int CaunPlus;															//36 счетчик +
		   int CaunMin;	
		   															                //37 счетчик -  
		   int CaunPlusRateAdd;															//36 счетчик +
		   int CaunMinRateAdd;
		   int CaunPlusRate;															//36 счетчик +
		   int CaunMinRate;
		   
		   int CaunPlusReperAdd;															//36 счетчик +
		   int CaunMinReperAdd;
		   int CaunPlusReper;															//36 счетчик +
		   int CaunMinReper;
		// данные АЦП
		   unsigned int TermoNKU;													//38
		   unsigned int Termo;														//39 значение АЦП
		   unsigned int DeltaT;														//40
		    int In1;														//41
		    int In2;														//42
		   int Tmp_OffsetT4;  												        //47
		   int Tmp_OffsetT5;  
		   float Tmp_scaleT4;  														//53      	 				
	       float Tmp_scaleT5;       	 											//54
		
		   unsigned int ADF_Accum;													//43 Значенее амплитудного детектора Временное
		   unsigned int ADS_Accum;
		   unsigned int IN1_Accum;		
		   unsigned int IN2_Accum;	
		   unsigned int DacIn;											            //44 Значенее амплитудного детектора Временное
		   unsigned int ADS_AccumTermLM;                                            //45
		   unsigned int TermLM;														//46
		   unsigned int ADF_Count;	
		   unsigned int ADM_Count;													//47 Значенее времени накопления данных
		   unsigned int ADS_Count;													//48 Значенее времени накопления данных
		   unsigned int AD_Fast;													//49 Значенее амплитудного детектора		сдвинутое на 16 бит
		   unsigned int AD_Slow;													//50 Значенее амплитудного детектора		сдвинутое на 16 бит
		   unsigned int ADF_NewData;												//51 есть данные после фильтрации в быстром фильтре		
		   unsigned int ADS_NewData;												//52 -----------/----------/----------/--------
		 
		 
		   int DownTreshold;  																//27
		   int HighTreshold;  	
		   int PLCDelay;  	
		   int ResetLevelCool; 																//105
	   	   int ResetLevelHeat; 			
		 
		 
		   int PLC_Error2Mode; 														//53 счетчик, не ноль когдав двух модовом регулировка без модулятора(для просмотра мод)
		
		   unsigned int CMD_In;														//54 входящая команда
		   unsigned int SOC_Out;													//55
		   unsigned int My_Addres;													//56 адрес прибора
		   unsigned int DropDelayGLD;												//57 задержка для мультидропа (дискрета 100кГц)
		   
		   unsigned int GLD_Serial;													//58 серийный номер прибора
		   unsigned int CRC;														//59 контрольная сумма посылки
		   unsigned int Firmware_Version; 											//60 версия программы
		   unsigned int RsErrLine;         											//61 регистр ошибок передачи.
		   unsigned int Device_Mode;
		   int CuruAngle;	
		   int CuruAngle32;																//62 текущеий угол.
		   int CuruAngle64;
		   int CuruAngle96;
		   int CuruAngle128;
		   int OldCuruAngle;														//63 старый угол
		   int CuruAngleLog;
		   int	Cnt_Dif;															//64 приращение угла между прошлым и текушим приращением за тик виброподвеса (32 тика)
		    
		   unsigned int PinReg;     												//65          bit4             bit3                  bit 2                 bit1                 bit0
		   unsigned int PinRegOld;  												//66  || светодиод || состояние поджига  || состояние подсветки || состояние вибро 2 || состояние вибро 1 ||
		
		   unsigned int Discharg;   												//67 последовательность бит харрактеризующая форму сигнала поджига.
		   unsigned int BackLight; 													//68 последовательность бит харрактеризующая форму сигнала подсветки.
	       unsigned int LaserOn;
		   unsigned int EXT_Latch;													//69
} GyroT, *Gyro_p;
extern GyroT Gyro;

typedef  union {
    int Array[248];
    struct {
      				    unsigned int My_Addres;									//0 адрес прибора
 						unsigned int HFO_ref; 									//1
						unsigned int HFO_Gain;									//2
       					unsigned int DAC_current_Work;							//3    HFO_MIN
                        unsigned int DAC_current_Start;                         //4    HFO_MAX

unsigned int TimeToJump;  	                     						            	//5
unsigned int JumpDelta;  		        								     			//6

unsigned int PLC_Phase;         												//7
int PLC_Gain;															//8

						unsigned int PLCDelay;  								//9
						
						
						unsigned int DownTreshold; 										//10
						unsigned int HighTreshold; 										//11
						
						
	   					unsigned int FrqPhase;									//12 фаза
	   					unsigned int FrqChengSpeed;								//13 скорость регулировки  частоты ВП	   					
						unsigned int FrqHZ;										//14
						unsigned int FrqHZmin;									//15
						unsigned int FrqHZmax;									//16
						unsigned int VB_Fdf_Hi;									//17
						unsigned int VB_Fdf_Lo;									//18
						unsigned int AmpSpeed;  								//19
						unsigned int AmpPerMin;									//20
						unsigned int AmpPerMax;									//21
 						unsigned int AmpPer;									//22
						unsigned int AmpMin;									//23 минимальное  значение AmpT(частота ошумления);
						unsigned int AmpTD;										//24 диапозон частоты ошумления(частота ошумления);
 						unsigned int AmpPerDel;									//25 амплитуда ошумления
unsigned int a9;  																//26
int a10;  																		//27
int a11;																		//28
unsigned int a12;  																//29
						unsigned int LG_Type;  									//30
 						int  ResetLevelHeatAAA; 								//31
unsigned int a15;  																//32
unsigned int ShiftMod;   														//33
						unsigned int ModAmp;   									//34 амплитуда модулятора
						
unsigned int a17;  																//35
unsigned int a18;  																//36
unsigned int a19;  																//37
unsigned int a20;  																//38
						int ResetLevelCoolAAA;  									//39
unsigned int a22;  																//40
unsigned int a23;  																//41
unsigned int a24;  																//42	
unsigned int a25;  																//43
unsigned int a26;  																//44
unsigned int a27;  																//45
unsigned int a28;  																//46
					
						unsigned int Tmp_OffsetT4;  							//47
						unsigned int Tmp_OffsetT5;  							//48

unsigned int a29;  																//49
unsigned int a30;        								 						//61 0 - Mirror 1 - Prizm.
unsigned int a32;  																//51
unsigned int a33;  														//52

						unsigned int Tmp_scaleT4;  								//53      	 				
						unsigned int Tmp_scaleT5;       	 					//54

					unsigned	int /*RLH*/ResetLevelHeat;												//55 
       	 				
       	 				unsigned int Gain_Sin;									//56 коиф усиления синуса.
	   					unsigned int Gain_Cos;									//57 коиф усиления косинуса.
						unsigned int Header_Word;       	 			  		//58 Признак достоверности	   					
       	 				unsigned int ParamMod;                                  //59
       	 			    unsigned int GLD_Serial;								//60 серийный номер прибора
       	 			    
						unsigned int PLC_Start;        	 						//61 0 - Mirror 1 - Prizm.

						unsigned int TermoMode;									//62 серийный номер прибора	  

unsigned int a36;  																//63
unsigned int a37;  																//64
unsigned int a38;  																//65
unsigned int a39;  																//66
unsigned int a40;  																//67
unsigned int a41;  																//68
unsigned int a42;  																//69
unsigned int a43;  																//70
unsigned int a44;  																//71
unsigned int a45;  																//72
unsigned int a46;  																//73
unsigned int a47;  																//74
unsigned int a48;  																//75
unsigned int a49;  																//76
unsigned int a50;  																//77
unsigned int a51;  																//78	
unsigned int a52;  																//79
unsigned int a53;  																//80
unsigned int a54;  																//81
unsigned int a55;																		//82 должен быть на 31
unsigned int a56;  																//83
unsigned int a57;  																//84
unsigned int a58;  																//85
unsigned int a59;  																//86
unsigned int a60;  																//87
unsigned int a61;  																//88
unsigned int a62;  																//89
unsigned int a63;  																//90
unsigned int a64;  																//91
unsigned int a65;  																//92
unsigned int a66;  																//93
unsigned int a67;  																//94
unsigned int a68;  																//95
unsigned int a69;  																//96
unsigned int a70;  																//97
unsigned int a71;  																//98	
unsigned int a72;  																//99
unsigned int a73;  																//100
unsigned int a74;  																//101
unsigned int a75; 																//102
unsigned int a76;  																//103
unsigned int a77; 																//104

					unsigned	 int /*RLC;*/ResetLevelCool;  										//105 временно должен быть на 39

unsigned int a79; 																//106
unsigned int a80; 																//107

unsigned int a81;  																//108	
unsigned int a82;  																//109
unsigned int a83;  																//110
unsigned int a84;  																//111
unsigned int a85; 																//112
unsigned int a86;  																//113
unsigned int a87; 																//114
unsigned int FlashMod;  														//115
unsigned int a89; 																//116

unsigned int TSHeat0;  															//117
unsigned int TSHeat1;  															//118	
unsigned int TSHeat2;  															//119
unsigned int TSHeat3;  															//120
unsigned int TSHeat4;  															//121
unsigned int TSHeat5; 															//122
unsigned int TSHeat6;  															//123
unsigned int TSHeat7; 															//124
unsigned int TSHeat8; 															//125
unsigned int TSHeat9; 															//126
unsigned int TSHeat10; 															//127
unsigned int TSHeat11;  														//128	
unsigned int TSHeat12;  														//129
unsigned int TSHeat13;  														//130

unsigned int TermoDataHeat0;  													//131
unsigned int TermoDataHeat1;  													//132	
unsigned int TermoDataHeat2;  													//133
unsigned int TermoDataHeat3;  													//134
unsigned int TermoDataHeat4;  													//135
unsigned int TermoDataHeat5; 													//136
unsigned int TermoDataHeat6;  													//137
unsigned int TermoDataHeat7; 													//138
unsigned int TermoDataHeat8; 													//139
unsigned int TermoDataHeat9; 													//140
unsigned int TermoDataHeat10; 													//141
unsigned int TermoDataHeat11;  													//142	
unsigned int TermoDataHeat12;  													//143
unsigned int TermoDataHeat13;  													//144
unsigned int TermoDataHeat14;  													//145
unsigned int TermoDataHeat15; 													//146
unsigned int TermoDataHeat16;  													//147
unsigned int TermoDataHeat17; 													//148
unsigned int TermoDataHeat18; 													//149
unsigned int TermoDataHeat19; 													//150
unsigned int TermoDataHeat20; 													//151
unsigned int TermoDataHeat21;  													//152	
unsigned int TermoDataHeat22;  													//153
unsigned int TermoDataHeat23;  													//154
unsigned int TermoDataHeat24;  													//155
unsigned int TermoDataHeat25; 													//156
unsigned int TermoDataHeat26;  													//157
unsigned int TermoDataHeat27; 													//158

unsigned int Step; 																//159

unsigned int TSCool0;  															//160
unsigned int TSCool1;  															//161	
unsigned int TSCool2;  															//162
unsigned int TSCool3;  															//163
unsigned int TSCool4;  															//164
unsigned int TSCool5; 															//165
unsigned int TSCool6;  															//166
unsigned int TSCool7; 															//167
unsigned int TSCool8; 															//168
unsigned int TSCool9; 															//169
unsigned int TSCool10; 															//170
unsigned int TSCool11;  														//171	
unsigned int TSCool12;  														//172
unsigned int TSCool13;  														//173

unsigned int TermoDataCool0;  													//174
unsigned int TermoDataCool1;  													//175	
unsigned int TermoDataCool2;  													//176
unsigned int TermoDataCool3;  													//177
unsigned int TermoDataCool4;  													//178
unsigned int TermoDataCool5; 													//179
unsigned int TermoDataCool6;  													//180
unsigned int TermoDataCool7; 													//181
unsigned int TermoDataCool8; 													//182
unsigned int TermoDataCool9; 													//183
unsigned int TermoDataCool10; 													//184
unsigned int TermoDataCool11;  													//185	
unsigned int TermoDataCool12;  													//186
unsigned int TermoDataCool13;  													//187
unsigned int TermoDataCool14;  													//188
unsigned int TermoDataCool15; 													//189
unsigned int TermoDataCool16;  													//190
unsigned int TermoDataCool17; 													//191
unsigned int TermoDataCool18; 													//192
unsigned int TermoDataCool19; 													//193
unsigned int TermoDataCool20; 													//194
unsigned int TermoDataCool21;  													//195	
unsigned int TermoDataCool22;  													//196
unsigned int TermoDataCool23;  													//197
unsigned int TermoDataCool24;  													//198
unsigned int TermoDataCool25; 													//199
unsigned int TermoDataCool26;  													//200
unsigned int TermoDataCool27; 													//201

/*
unsigned int a84;  																//131
unsigned int a85; 																//132
unsigned int a86;  																//133
unsigned int a87; 																//134
unsigned int a88;  																//135
unsigned int a89; 																//136


	
	   unsigned int Firmware_Version; 											//1 версия программы
	   unsigned int DropDelayGLD;												//3 задержка для мультидропа (дискрета 100кГц)
	   
	   unsigned int Gain_Sin;													//7 коиф усиления синуса.
	   unsigned int Gain_Cos;													//8 коиф усиления косинуса.

	   unsigned int FrqHZ;     													//9 Частота в Гц.
	   unsigned int FrqHZmin;													//10 Мин значение частоты ВП
	   unsigned int FrqHZmax;  													//11 Мах  значение частоты ВП

       unsigned int AmpPer;             									    //13 начальное значение амплитуды
	 														
	  
	   unsigned int AmpPerDel;													//16 значение для расчета амплитуды (дельта амплитуды) на сколько будет отличаться в працентах 1 амплитуда от второй при ошумлении, мин знач : AmpPer, мах знач : AmpPer+AmpPerDel; (в процентах)
	   unsigned int AmpPerMin; 													//17 ограничение минимальной  амплитуды ВП
	   unsigned int AmpPerMax; 													//18 ограничение максимальной амплитуды ВП
	   unsigned int AmpSpeed;  													//19 коиффициент сорости регулировки амплитуды
	   unsigned int AmpTarget; 													//20 целевая амплитуда ВП к которой стремится регулировка.
	   
       unsigned int TermoNKU;   												//21
	       	   
	   
	   
	    

	   unsigned int  DAC_B;														//25
	   unsigned int  Try_Discarg;
	  */ 
//unsigned int PLC_Lern; 														//3 обратный таймер для поиска максимальной амплитуды при работе без модулятора
//unsigned int Frq; 															//6 Непосредственное значение частоты для таймера.
   } Str;
} GyroParam; 
/*
typedef  union {
    int Array[70];
    struct {
   	   unsigned int	LogPLC;														// 1
	   unsigned int	Log;														// 2
	
	   unsigned int	PLC_Lern; 													// 3 обратный таймер для поиска максимальной амплитуды при работе без модулятора
	   unsigned int ModAmp;   													// 4 амплитуда модулятора
	   
	   unsigned int FlashMod; 													// 5 0-ничего не делать, 1 - запись во Flash, 2 чтение из Flash.
	   unsigned int ModeOut;													// 6 переменная для выбора варианта вывода параметров типа Rate.
	  
	   unsigned int Rate1_Event;												// 7 событие 1с для вывода параметров Rate 1
	   unsigned int Reper_Event;												// 8 событие для вывода набора параметров типа Rate по меандру.
	   unsigned int Event_500Hz;
	
	   unsigned int RgConA;														// 9 регистр управления ГЛД
	   unsigned int RgConB;														//10 регистр управления ГЛД

	   unsigned int Gain_Sin;													//11 коиф усиления синуса.
	   unsigned int Gain_Cos;													//12 коиф усиления косинуса.
	   unsigned int Frq;      													//13 Непосредственное значение частоты для таймера.
	   unsigned int FrqHZ;     													//14 Частота в Гц.
	   unsigned int FrqHZmin;													//15 Мин значение частоты ВП
	   unsigned int FrqHZmax;  													//16 Мах  значение частоты ВП
	   unsigned int FrqChengSpeed;												//17 скорость регулировки  частоты ВП
	    
	   unsigned int VibroFrqRegulF;												//18 флаг регулировки частоты ВП
	   unsigned int VibroAMPRegulF;												//19 флаг регулировки амплитуды ВП
	   unsigned int VibroNoiseF;												//20 флаг ошумления амплитуды ВП
	   unsigned int VibroOutF;  												//21 флаг изменения состояния ножек вибро.
	    
	    
	   unsigned int Amp;														//22 значение амплитуды вибропривода в попугаях (Gyro.Amp = (0%--100%) << 16)
	   unsigned int AmpPer;														//23 Амплитуда в процентах Gyro.AmpPer = Gyro.Amp>>16	;
	   unsigned int AmpT;     													//24 значение тиков после которых происходит смена амплитуды ошумления ( rand() % Gyro.AmpTD+Gyro.AmpMin)(частота ошумления)
	   unsigned int AmpMin;														//25 минимальное  значение AmpT(частота ошумления);
	   unsigned int AmpTD;														//26 диапозон частоты ошумления(частота ошумления);
	  
	   unsigned int AmpPerMin; 													//27 ограничение минимальной  амплитуды ВП
	   unsigned int AmpPerMax; 													//28 ограничение максимальной амплитуды ВП
	   unsigned int AmpSpeed;  													//29 коиффициент сорости регулировки амплитуды
	   unsigned int AmpTarget; 													//30 целевая амплитуда ВП к которой стремится регулировка.
	   unsigned int AmpPerDel;													//31 значение для расчета амплитуды (дельта амплитуды) на сколько будет отличаться в працентах 1 амплитуда от второй при ошумлении, мин знач : AmpPer, мах знач : AmpPer+AmpPerDel; (в процентах)
	   unsigned int AmpN1;    													//32 левая граница импулься ВП
	   unsigned int AmpN2;    													//33 правая граница импулься ВП
	   unsigned int F_ras;														//34 частота расщипления (не расчитывается)
	   int			 MaxAmp;            										//35 амплитуда Пик-Пик расчтитанная по востановленному синусу. 
	
	//ЭНКОДЕР
	   int CaunPlus;															//36 счетчик +
	   int CaunMin;																//37 счетчик -  
	    
	// данные АЦП
	   unsigned int TermoNKU;													//38
	   unsigned int Termo;														//39 значение АЦП
	   unsigned int DeltaT;														//40
	   unsigned int In1;														//41
	   unsigned int In2;														//42
	    
	//пятый ацп, он же амплитудный детектор "AD". есть два фильтра быстрый "Fast" и медленный "Slow"
	   unsigned int ADF_Accum;													//43 Значенее амплитудного детектора Временное
	   unsigned int ADS_Accum;													//44 Значенее амплитудного детектора Временное
	   unsigned int ADS_AccumTermLM;                                            //45
	   unsigned int TermLM;														//46
	   unsigned int ADF_Count;													//47 Значенее времени накопления данных
	   unsigned int ADS_Count;													//48 Значенее времени накопления данных
	   unsigned int AD_Fast;													//49 Значенее амплитудного детектора		сдвинутое на 16 бит
	   unsigned int AD_Slow;													//50 Значенее амплитудного детектора		сдвинутое на 16 бит
	   unsigned int ADF_NewData;												//51 есть данные после фильтрации в быстром фильтре		
	   unsigned int ADS_NewData;												//52 -----------/----------/----------/--------
	 
	   int PLC_Error2Mode; 														//53 счетчик, не ноль когдав двух модовом регулировка без модулятора(для просмотра мод)
	
	   unsigned int CMD_In;														//54 входящая команда
	   unsigned int SOC_Out;													//55
	   unsigned int My_Addres;													//56 адрес прибора
	   unsigned int DropDelayGLD;												//57 задержка для мультидропа (дискрета 100кГц)
	   
	   unsigned int GLD_Serial;													//58 серийный номер прибора
	   unsigned int CRC;														//59 контрольная сумма посылки
	   unsigned int Firmware_Version; 											//60 версия программы
	   unsigned int RsErrLine;         											//61 регистр ошибок передачи.
	    
	   int  CuruAngle;															//62 текущеий угол.
	   int  OldCuruAngle;														//63 старый угол
	   int	Cnt_Dif;															//64 приращение угла между прошлым и текушим приращением за тик виброподвеса (32 тика)
	    
	   unsigned int PinReg;     												//65          bit4             bit3                  bit 2                 bit1                 bit0
	   unsigned int PinRegOld;  												//66  || светодиод || состояние поджига  || состояние подсветки || состояние вибро 2 || состояние вибро 1 ||
	
	   unsigned int Discharg;   												//67 последовательность бит харрактеризующая форму сигнала поджига.
	   unsigned int BackLight; 													//68 последовательность бит харрактеризующая форму сигнала подсветки.
	    
	   unsigned int EXT_Latch;													//69

	   unsigned int wall;													    //70
	   unsigned int ParamMod    ;                                               //71
   } Str;
} GyroParam;  */
extern 	GyroParam GyroP;

extern void AllRegul (void);
extern unsigned int amp;
extern int  Rate2VibFlag;
extern void cheng(void);

extern void VibroOut(void);

extern void VibroAMPRegul(void);
extern void VibroFrqRegul(void);
extern unsigned int FrecTp;
extern int Pulse_midl;
extern struct VIBRO Vib;
extern int PulseHalf;
extern int CuruAngle;
extern unsigned int FrecTemp;
#endif

