/**--------------File Info---------------------------------------------------------------------------------
** File name:           CycleSync.h
** Last modified Date:  2011-09-06
** Last Version:        V1.00
** Descriptions:
**
**--------------------------------------------------------------------------------------------------------
** Created by:          Electrooptica Inc.
** Created date:        2011-09-06
** Version:             V1.00
** Descriptions:        There is the routines for device synchronization
**
**--------------------------------------------------------------------------------------------------------
*********************************************************************************************************/
#include "LPC17xx.h"
#include "CntrlGLD.h"

//#define 	PERFOMANCE

//#define 	PERFOMANCE

#define	DEVICE_SAMPLE_RATE_HZ		10000		//e. sampling frequency 10 kHz //r. частота дискретизации 10 кГц
#define	DEVICE_SAMPLE_RATE_uks		100000000		//e. sampling frequency 10 kHz //r. частота дискретизации 10 кГц
#define DELAY_UART_ENBL				4000			//e. delay = DELAY_UART_ENBL*8/CLCK
#define DELAY_UART_DISBL			2500			//e. delay = DELAY_UART_ENBL*8/CLCK
#define RATE_REPER_OR_REFMEANDR 	0x0000		//e. difference of general counters (not dither counters), latched by Reper or by Sign Meander //r. разность обычных счетчиков (не вибросч), защелкнутых по Reper`у или по RefMeandr`у
#define RATE_VIBRO_1	 			0x0001      //e. difference of dither counters after the filter of moving average //r. разность вибросчетчиков после фильтра скольз.среднего

#define  HALF_PERIOD				0x00000004
#define  WHOLE_PERIOD				0x00000008
#define  RESET_PERIOD				0x0000000C
//-----------------------------PWM Registers----------------------------------------

#define TCR_CNT_EN		0x00000001
#define TCR_RESET		0x00000002
#define TCR_PWM_EN		0x00000008

#define PWMMR0I			(1 << 0)
#define PWMMR0R			(1 << 1)
#define PWMMR0S			(1 << 2)
#define PWMENA1			(1 << 9)
#define LER0_EN			(1 << 0)

//-----------------------Drive cycle registers------------------------------------
#define MR0_RESET		0x00000002
#define MR1_RESET		0x00000010
#define MR1_STOP		0x00000020
#define MR0_STOP		0x00000004
#define MR0_NO_STOP		0x00000000
#define MR0_INT_EN		0x00000001
#define SYNC_CLCK4		0xffff3fff
#define SYNC_CLCK		0xfffffff

//------------------------WDT registers--------------------------------------------
#define WDEN		(0x1<<0)
#define WDRESET		(0x1<<1)
#define WDTOF		(0x1<<2)
#define WDINT		(0x1<<3)
#define WDT_FEED_VALUE	0x003FFFFF

extern uint32_t		WDTInit( void );
extern void 		WDTFeed( void );
extern uint32_t 	Sys_Clock;
extern  int32_t 	time_1_Sec;
extern uint32_t  	trm_cycl;
extern  int32_t 	PrevPeriod;
extern uint32_t 	Ext_Latch_ResetEnable;
extern volatile uint32_t		Latch_Rdy;
extern volatile uint32_t		data_Rdy;
extern  int32_t  	LatchPhase;
extern uint32_t		PeriodElapsed;
extern uint32_t		count;
extern uint32_t main_cycle_latch;
extern uint32_t Out_main_cycle_latch; //e. counter of main cycles between external latch pulse appearence
extern uint32_t T_latch, Out_T_latch, temp_T_latch;

extern void CounterIquiryCycle_Init(uint32_t);
extern void ExtLatch_Init(void);
extern void IntLatch_Init(void);
extern void Latch_Event(void);
extern void SetIntLatch(uint32_t);
extern void SwitchRefMeandInt(uint32_t);
extern int SwitchMode(void);

#if defined PERFOMANCE
void IntLatch(void);
#endif

void ServiceTime(void);

/*****************************************************************************
**                            End Of File
******************************************************************************/
