#include "Global.h"
INPUT Input;
//OUTPUT Output;

volatile uint32_t I2CMasterState = I2C_IDLE;
volatile uint32_t I2CMasterBuffer[I2C_WRITELENGTH];

int ExchangeErr = 0;  
//----------------------temp---------------------
extern char test;
/******************************************************************************
** Function name:		G_Photo_Exchange
**
** Descriptions:		Driver for I2C exchange 
**
** parameters:			None
** Returned value:		None
** 
******************************************************************************/

void G_Photo_Exchange(void) 
{
  		 uint32_t StatValue;
  static uint32_t WrIndex;
  static  int32_t time_out = TIMEOUT;

 if (I2CMasterState)
  return;							//e.transmitting is not active, go away

    if (--time_out < 0) 		   //e. valid time period elapsed, go away
	{
	   	time_out = TIMEOUT;
	  	I2CMasterState = I2C_IDLE;	 	//e. timer elapsed, go away
		LPC_I2C0->CONSET = I2CONSET_STO;      //e. Set Stop flag 	
        LPC_I2C0->CONCLR = I2CONCLR_AAC | I2CONCLR_SIC | I2CONCLR_STAC;  
		return;	
	}
	else if (!(LPC_I2C0->CONSET & I2CONSET_SI))		//e. state of I2C bus has not been changed
   		return;

	StatValue = LPC_I2C0->STAT;

  switch ( StatValue )
  {
	case 0x08:			// A Start condition is issued (write data for the first potentiometer) 
	WrIndex = 0;
	time_out = TIMEOUT;  //e. enable countdown
	LPC_I2C0->DAT = I2CMasterBuffer[WrIndex++];	   //e. send address
	LPC_I2C0->CONCLR = (I2CONCLR_SIC | I2CONCLR_STAC); //e .clear interrupt bit and start bit
	break;
	
	case 0x10:			// A repeated started is issued (write data for the second potentiometer) 
	LPC_I2C0->DAT = I2CMasterBuffer[WrIndex++];	   //e. send address
	LPC_I2C0->CONCLR = (I2CONCLR_SIC | I2CONCLR_STAC); //e .clear interrupt bit and start bit
	break;

	case 0x18:			//e. Regardless, it's a ACK after slave address reading
	LPC_I2C0->DAT = I2CMasterBuffer[WrIndex++];  //e. send another byte
	LPC_I2C0->CONCLR = I2CONCLR_SIC;	//e. clear interrupt bit
	break;

	case 0x28:	//e. Regardless it's a ACK after data byte 
	if  (WrIndex == I2C_WRITELENGTH) //e. we have transmitted the data for the B potentiometer
	{  
	  I2CMasterState = I2C_IDLE;
	 LPC_I2C0->CONSET = I2CONSET_STO;      //e. Set Stop flag
	// Output.Str.Cnt_Dif = 300;
	}
	else if (WrIndex == 3)
	{
	 LPC_I2C0->CONSET = I2CONSET_STA; 
	// Output.Str.Cnt_Dif = 200;
	}
	else
	{
	  LPC_I2C0->DAT = I2CMasterBuffer[WrIndex++];  //e. send another byte	
	 // Output.Str.Cnt_Dif = 100;
	}
	LPC_I2C0->CONCLR = I2CONCLR_SIC;	//e. clear interrupt bit
	break;

	case 0x20:							  //e. no aknowledgement after address transmitting
	case 0x30:							  //e. no aknowledgement after data block transmitting
    LPC_I2C0->CONSET = I2CONSET_STO;      //e. Set Stop flag 
	LPC_I2C0->CONCLR = (I2CONCLR_SIC | I2CONCLR_STAC); 
	I2CMasterState = I2C_IDLE;	  //e. fix new state
	break;
  }
  return;
}
/******************************************************************************
** Function name:		DAC_ADC_Exchange
**
** Descriptions:		Loading data to DACs and initialization of ADC reading 
**
** parameters:			None
** Returned value:		None
** 
******************************************************************************/
void DAC_ADC_Exchange()
{
  //-------------------------loading data from ADC to buffer---------------------------------------
//int x;
   	ExchangeErr &= ~ADC_ERR_MSK;		   //e. сбросить флаг ошибки
  if (LPC_SSP0->SR & SSP_BUSY)	   		   //e. если буфер передатчика не полон
   {
     	ExchangeErr |= ADC_ERR_MSK;		   //e. установить флаг ошибки
   } 
    else
        {
         LPC_SSP0->DR =  0x8001; //записать 0x8001 в регистр передачи.
    	   if (WRITE_DAC0 & 1)//если нечетный такт то
	         {
	        	LPC_SSP0->DR = WRITE_DAC0;   					//e.команда для ЦАП_0 передавать.
          //	LPC_SSP0->DR = (-Output.ArrayOut[3]+32767);  	//e. передача 12 бит
  	       } 
	          else //если такт четный.
	              {
	               LPC_SSP0->DR = WRITE_DAC1 ;   					//e.команда для ЦАП_1 передавать.
		         //    LPC_SSP0->DR = (Output.ArrayOut[0]<<1) & 0xFFF0; 		//e. передача 12 бит
	              } 		 
        }
}
/******************************************************************************
** Function name:		ADC_Input
**
** Descriptions:		Reading data from ADC 
**
** parameters:			None
** Returned value:		None
** 
******************************************************************************/
void ADC_Input()
{ 
   uint32_t Dummy;

   //---------------------read data from ADC buffer---------------------------------------------
  Dummy = Dummy;
  ExchangeErr &= ~ADC_ERR_MSK;

  if (LPC_SSP0->SR & SSP_BUSY)	  					//если буфер фифо не полный(передача ативна)
  {	    ExchangeErr |= ADC_ERR_MSK;         //установить флаг ошибки
		
    if (!(LPC_SSP0->SR & TX_SSP_EMPT))			//буфер передачи не пуст.
  	    ExchangeErr |= ADC_ERR_MSK;         //установить флаг ошибки
  }
  else							 					//обмен закончен прочитать буфер.
  {	 
	  Input.ArrayIn[0] = LPC_SSP0->DR;		 //чтениеThermo2 
		Input.ArrayIn[1] = LPC_SSP0->DR;		//чтение Thermo1
		Input.ArrayIn[2] = LPC_SSP0->DR;		//чтение HF_out

	    while (LPC_SSP0->SR & RX_SSP_notEMPT)  		//если буфер SPI не пуст.
			Dummy = LPC_SSP0->DR;	                   //очистить буфер.
  }
   

}
/*****************************************************************************
** Function name:		DAC_Output
**
** Descriptions:		Output data to intrnal DAC
**
** parameters:			output - code for output
** Returned value:		None
** 
*****************************************************************************/
void DAC_O456utput(int output)
{
//	LPC_DAC->CR = (output<<6);
	return;
}
/******************************************************************************
** Function name:		G_Photo_Init
**
** Descriptions:		Initialization of exchange with digital potentiometers
**
** parameters:			None
** Returned value:		None
** 
******************************************************************************/

/******************************************************************************
** Function name:		DAC_ADC_Exchange_Init
**
** Descriptions:		Initialization of data exchange with DACs and ADCs
**
** parameters:			None
** Returned value:		None
** 
******************************************************************************/

/*****************************************************************************
** Function name:		DACInit
**
** Descriptions:		initialize DAC channel
**
** parameters:			None
** Returned value:		None
** 
*****************************************************************************/
void DACInit( void )
{
  /* setup the related pin to DAC output */
  LPC_PINCON->PINSEL1 |= 0x00200000;	/* установить p0.26  как выход ЦАП */   
 // LPC_GPIO0->FIODIR |= (1<<26);  
  LPC_DAC->CNTVAL = 0;               // ккаието параметры 
  LPC_DAC->CTRL = 0;	               // для  ДМА
  return;
}
/******************************************************************************
** Function name:		Out_G_photo
**
** Descriptions:		Start of potentiometer data writing process
**
** parameters:			pointer to gain factors
** Returned value:		None
** 
******************************************************************************/
void  Out_G_photo(uint32_t Ph_A, uint32_t Ph_B)
{
	I2CMasterBuffer[2] = 255-Ph_A;// запись в буфер I2C мастера данных с А канала фото датчика.(уточнить)
	I2CMasterBuffer[5] = 255-Ph_B;// запись в буфер I2C мастера данных с В канала фото датчика.(уточнить)
	GyroP.Str.Gain_Sin    = Ph_A;
	GyroP.Str.Gain_Cos	  = Ph_B;	 
  LPC_I2C0->CONSET = I2CONSET_STA;	// установить старт флаг.
  I2CMasterState = I2C_BUSY;  // установить флаг занятой шины.
 }

