#include "Global.h"

#define COMMAND_DEBUG

uint32_t 	SRgR;      		     //r. системный регистр режима платы ADSP

//uint32_t 	RgConA;            //r. основной регистр управления устройства
//uint32_t 	RgConB;            //r. дополнительный регистр управления
//uint32_t	Copy_e5_RgR;     //r. копия регистра режима платы E5
//uint32_t	Copy_e5_RgRA;    //r. копия дополнительного регистра режима E5

uint32_t	Valid_Data;   //r. байт-признак достоверных данных, накапливающий ошибки от запроса до запроса

//TDEVICE_BLK Device_blk;   //e. union for device constants
uint32_t	ser_num;	 //e. device serial number

int 	Device_Mode = DM_INT_10KHZ_LATCH;  //r. режим работы прибора (внутр.защелка, знаковый меандр или внешняя защелка)

void Sts_Pulse(void);
void Sts_Pause(void);
void Sts_Polling(void);

//r. таблица состояний процедуры запуска прибора
void 	(* Tab_Gld_Start[3])(void) = {Sts_Pulse, Sts_Pause, Sts_Polling};
//r. таблица состояний процедуры поджига лазера
void	(* Tab_Gld_Pulse[1])(void) = {Sts_Pulse};

//e. stack of states of the procedure of starting //r. стек параметров состояний процедуры запуска
uint32_t		Stk_Gld_Start[3] = {LIGHT_UP_PULSE_WDTH, LIGHT_UP_PAUSE, LIGHT_UP_POLLING};

uint32_t		gyro_Sts = 0;       //r. регистр состояния прибора
uint32_t		start_Rq = 1;       //r. запрос на запуск прибора
uint32_t		start_Go = 0;       //r. процедура запуска активна
uint32_t		stop_Rq = 0;        //r. запрос на останов прибора
uint32_t		pulse_Rq = 0;       //r. запрос на поджиг лазера
uint32_t		pulse_Go = 0;       //r. процесс поджига активен

uint32_t     	state_index;    //r. индекс состояния процедуры (старта)
uint32_t     	sts_work;       //r. 1 - текущее состояние - в рабочей фазе, 0 - инициализации
uint32_t     	sts_time;       //r. счетчик времени текущего состояния
uint32_t     	attempt_Str;    //r. счетчик попыток запуска прибора


uint32_t 		BIT_number;
uint32_t		Is_BIT = 0;

void GLD_Stop(void)	//e.---------- procedure of GLD stopping -------------------------------------- //r.---------- процедура останова ГЛД --------------------------------------
{
    if (!stop_Rq) { //r. проверить запрос на выключение прибора
        return;		//r. если нет, возврат
    }

    //r. сбросить флаги
    start_Rq = 0;       //r. запроса включения,
    start_Go = 0;       //r. активности процесса запуска прибора,
    stop_Rq  = 0;       //r. запроса останова
   // open_all_loops();   //r. выключить все контура регулирования

    gyro_Sts = 0;       //r. сброс регистра состояния аппаратуры ГЛД

    //r. установка значений покоя выходных параметров регуляторов
#if !defined COMMAND_DEBUG
    disable_DACs();
#endif
} // GLD_Stop
/*
void GLD_Status(void)     //r.---------- допусковый контроль параметров ГЛД --------------------------
{
    static uint32_t Device_Mode_Old = DM_INT_10KHZ_LATCH DM_EXT_LATCH_DELTA_SF_PULSE ;

    if ( loop_is_closed(GLD_ON) == 0 ) {
        open_all_loops();
        GLD_Stop();
    }
    if (Device_Mode_Old != Device_Mode) {	   //deviсe mode has been changed
        if (SwitchMode()) {					   //e. mode is changed successful
            Device_Mode_Old = Device_Mode;		   //e. save current mode name
            if (Device_Mode_Old == DM_INT_10KHZ_LATCH)
                trm_ena = 1;							   //e. enable answer
        }
    }
} // GLD_Status
*/
void Sts_Pause(void)      //r.------- процедура состояния паузы --------------------------------------
{
    if (sts_work) {    //r. состояние в активной фазе?
        sts_time--;      //r. декремент счетчика времени состояния
        if (sts_time > 0) {
            return;  //r. продолжать работу, пока счетчик положителен
        }
        //r. время состояния кончилось
        sts_work = 0;        //r. сбросить флаг активности
        state_index++;      //r. передвинуть указатель на следующее состояние
    } else {
        sts_time = Stk_Gld_Start[state_index];	 //r. время данного состояния
        sts_work = 1;         //r. установить флаг активной фазы
    }
} // Sts_Pause

void Sts_Pulse()      //r. ------- процедура состояния импульса поджига --------------------------
{
    if (sts_work) {   //r. состояние в активной фазе?
        sts_time--;       //r. декремент счетчика времени состояния
        if (sts_time > 0) {
            return; //r. продолжать работу, пока счетчик положителен
        }
        //r. время состояния кончилось
        sts_work = 0;       //r. сбросить флаг активности
        state_index++;     //r. передвинуть указатель на следующее состояние

        Set_LightUp;		 //r. снять сигнал поджига лазера

    } else {
        sts_time = Stk_Gld_Start[state_index];	//r. время данного состояния
        sts_work = 1;        //r. установить флаг активной фазы

        Reset_LightUp;		 //r. активировать сигнал поджига лазера

    }
} // Sts_Pulse

void Sts_Polling(void)        //r.========== процедура состояния измерения и принятия решения о запуске
{
    static int32_t Sum_F_ras = 0;      //r. интегральная сумма расщепления для процедуры старта

    if (sts_work) {    //r. состояние в активной фазе?
        if 	(Dif_Curr_Vib >0)
            Sum_F_ras = L_add(Sum_F_ras, Dif_Curr_Vib);
        else
            Sum_F_ras = L_sub(Sum_F_ras, Dif_Curr_Vib);

//r. нет, пропустить накопление суммы расщепления
        sts_time--;      //r. декремент счетчика времени состояния
        if (sts_time > 0) {
            return; //r. продолжать работу, пока счетчик положителен
        }
        //r. время состояния кончилось
        sts_work = 0;       //r. сбросить флаг активности
        state_index++;     //r. передвинуть указатель на следующее состояние
        //r. проверить наличие генерации
        if ( Sum_F_ras >= F_RAS_MIN) { //e. //r. F_RAS_MIN = 10000 ??? что это за единицы???
            gyro_Sts |= LASER_ON;      //r. иначе старт состоялся, отметить в регистре состояния
            return;                    //r. прибора и завершать процесс
        }
        //r. если она меньше, генерации нет
        attempt_Str--;           //r. декремент счетчика попыток запуска лазера
        if (attempt_Str <= 0) {
            return;       //r. если попытки закончены, завершить процесс
        }
        //r. иначе установить указатель состояний на
        state_index = 0;       //r. начало процесса запуска для повторной попытки
    } else {
        sts_time = Stk_Gld_Start[state_index];	//r. время данного состояния
        sts_work = 1;         //r. установить флаг активной фазы
        Sum_F_ras = 0;               //r. предсброс интегральной суммы расщепления
    }

} // Sts_Polling


//r.---------- процесс запуска прибора -------------------------------------
void GLD_Start(void)
{
    if (!start_Rq) {	//r. проверить состояние запроса на запуск прибора
        return;		 //r. запроса нет, возврат
    }

    if (!start_Go) { //r. процесс запуска еще не был активен?
        //r. это начало запуска
        attempt_Str = N_START_MAX;   //r. установить максимальное число попыток запуска
        //r. разомкнуть контура регуляторов
        //open_loop(VB_FREQ_ON | VB_TAU_ON | WP_REG_ON | HF_REG_ON); // 0xff95
        //close_all_loops();

        sts_work = 0;       //r. сбросить флаг активной фазы состояния
        state_index= 0;      //r. установить указатель состояний в начальное положение
        start_Go = 1;       //r. процесс старта начался
    }

    ( *Tab_Gld_Start[state_index] )();		 //r. вызов процедуры состояния по номеру в массиве

    if (sts_work) {    	 //r. текущее состояние окончено?
        return;			//r. продолжать ожидание
    }
    //r. состояние закончилось проверить указатель состояний
    if ( state_index >= 3 ) {
        //r. окончание процесса
        //r. сбросить флаги
        start_Rq = 0;       //r. запроса
        start_Go = 0;     //r. и активности процесса
#if !defined COMMAND_DEBUG
        Out_G_photo(Device_blk.Str.Gain_Ph_A, Device_blk.Str.Gain_Ph_B); 		 //r. повторно инициализировать коэф-ты передачи фотоприемников
#endif
        //  close_all_loops();

    }

} // GLD_Start

void GLD_Pulse(void)      //r.---------- процесс поджига лазера --------------------------------------
{
    if (!pulse_Rq) {   //r. проверить состояние запроса на поджиг лазера
        return; 		//r. запроса нет, возврат
    }

    if (!pulse_Go) {    //r. процесс поджига еще не был активен?
        sts_work = 0;      //r. сбросить флаг активной фазы состояния
        state_index = 0;     //r. установить указатель состояний в начальное положение
        pulse_Go = 1;       //r. процесс старта начался
    }

    ( *Tab_Gld_Pulse[state_index] )();		 //r. вызов процедуры состояния по номеру в массиве

    if (sts_work) {    	 //r. текущее состояние окончено?
        return;			//r. продолжать ожидание
    }

    if ( state_index >= 1 ) {
        //r. сбросить флаги
        pulse_Rq = 0;       //r. запроса
        pulse_Go = 0;      //r. и активности процесса
    }

} // GLD_Pulse
/*
void contrl_GLD(void)     //r.========== процедура управления прибором ===============================
{
    GLD_Start();   //r. запустить прибор, если есть запрос
  //  GLD_Status();  //r. проверка состояния прибора
    GLD_Stop();    //r. остановить прибор, если необходимо
    GLD_Pulse();   //r. генерация импульса поджига при наличии запроса
    GLD_Output();  //r. режимы выдачи данных из гироскопа
} */// contrl_GLD



