#ifndef __UART_H
#define __UART_H

#define PortEUART0 		LPC_GPIO4->FIOPIN
#define PortDirEUART0 LPC_GPIO4->FIODIR
#define PinEUART0 		1UL << 29

#define PortEUART1 		LPC_GPIO2->FIOPIN
#define PortDirEUART1 LPC_GPIO2->FIODIR
#define PinEUART1 		1UL << 2


#define PortEUART2 		LPC_GPIO2->FIOPIN
#define PortDirEUART2 LPC_GPIO2->FIODIR
#define PinEUART2 		1UL << 13

#define PortEUART3 		LPC_GPIO0->FIOPIN
#define PortDirEUART3 LPC_GPIO0->FIODIR
#define PinEUART3 		1UL << 24

void UART0_Init (void);
void UART1_Init_temp (void);
void UART2_Init (void);
void UART3_Init (void);

void UART2_InitSet 	(unsigned int speed, unsigned int SetLsr);
void UART3_InitSet 	(unsigned int speed, unsigned int SetLsr);
void UART_InitSet 	(unsigned int Num,unsigned int Speed, unsigned int SetLsr);



int  UART0_SendByte 	(int ucData);

int  UART0_GetChar (void);
int  UART1_GetChar (void);
int  UART2_GetChar (void);
int  UART3_GetChar (void);


int  UART0_Chek (void);
int  UART1_Chek (void);
int  UART2_Chek (void);
int  UART3_Chek (void);

void 	UART0_SendString (char *s); 
void 	UART2_SendString (char *s);


int  	UART2_SendByte (int ucData);
int  	UART2_SendByte_i (int ucData);
int  	UART2_GetChar (void);
int  	UART2_Chek (void);

void 	Concol ( void); 
void 	Concol1 ( void); 
void 	Concol2 ( void); 
void 	Concol3 ( void); 

void 	WriteCon 			(char *s);
void 	WriteCon1 		(char *s);
void 	WriteCon2 		(char *s);
void 	WriteConF (char *s, unsigned int Num);

void WriteConN (char *s, unsigned int N);
	
void 	WriteConByte 	(unsigned int In) ;
void 	WriteCon2Byte (unsigned int In) ;
void 	WriteCon3Byte (unsigned int In) ;

	
void 	WriteConByteF (unsigned int In,unsigned int Num ); 


int 	ReadCon (char *s); 
int 	ReadCon1 (char *s); 
int 	ReadCon2 (char *s); 
int 	ReadCon3 (char *s); 

int 	ReadChekCon (char *s); 
int 	ReadChekCon2 (char *s); 
int 	ReadChekCon3 (char *s); 

int 	ChekInCon ( void); 
int 	ChekInCon1 ( void); 
int 	ChekInCon2 ( void); 
int 	ChekInCon3 ( void); 

int 	ChekOutCon ( void); 
int 	ChekOutCon1 ( void); 
int 	ChekOutCon2 ( void); 
int 	ChekOutCon3 ( void); 



void SetDeUART0 (void);
void ClrDeUART0 (void);
void SetDeUART1 (void);
void ClrDeUART1 (void);
void SetDeUART2 (void);
void ClrDeUART2 (void);
void SetDeUART3 (void);
void ClrDeUART3 (void);




extern unsigned int 	OutBufConCount ;
extern unsigned int 	OutBufCon1Count;
extern unsigned int 	OutBufCon2Count;
extern unsigned int 	OutBufCon3Count;



#endif

