#ifndef InputOutput_H
#define InputOutput_H


#include "stdint.h"

//******************************I2C*************************************************	
#define I2C0

#define I2C_IDLE              1
#define I2C_BUSY              0

#define I2CONSET_I2EN       0x0000040  /* I2C Control Set Register */
#define I2CONSET_AA         0x0000004
#define I2CONSET_SI         0x0000008
#define I2CONSET_STO        0x0000010
#define I2CONSET_STA        0x0000020

#define I2CONCLR_AAC        0x0000004  /* I2C Control clear Register */
#define I2CONCLR_SIC        0x0000008
#define I2CONCLR_STAC       0x0000020
#define I2CONCLR_I2ENC      0x0000040

#define I2SCLH_SCLH			0x00000080  /* I2C SCL Duty Cycle High Reg */
#define I2SCLL_SCLL			0x00000080  /* I2C SCL Duty Cycle Low Reg */

#define I2C_WRITELENGTH		0x00000006	/*Buffer length*/
#define A_ADDRESS			0x0000005E	/*address of slave potentiometer (table 6-2 of pot's manual)*/
#define B_ADDRESS			0x0000005C	/*address of slave potentiometer (table 6-2 of pot's manual)*/
#define WRITE_CMD			0x00000000	/*address of wiper0 register in memory map*/

//********************************SPI************************************************
#define HALFWORDS_FOR_ADCs		3

#define WRITE_DAC0			0x00000030	//write data to DAC 0
#define WRITE_DAC1			0x00000031	//write data to DAC 1

#define	DAC					(1<<23)		//DAC identifer
#define ADC					(1<<16)		//ADC identifer

#define SetCS(a)			LPC_GPIO0->FIOSET = a	//set CS signal for ADC or DAC
#define ResetCS(a)			LPC_GPIO0->FIOCLR = a	//reset CS signal for ADC or DAC
#define SetDAC(a)			LPC_GPIO0->FIOSET = a	//set CS signal for ADC or DAC
#define ResetDAC(a)			LPC_GPIO0->FIOCLR = a	//reset CS signal for ADC or DAC



#define SSPCR1_SSE		 0x00000002

#define TX_SSP_EMPT		 0x00000001
#define RX_SSP_notEMPT	 0x00000004
#define TX_SSP_notFULL	 0x00000002
#define RX_SSP_FULL		 0x00000008
#define SSP_BUSY		 0x00000010

#define ADC_ERR_MSK		 0x00000001
#define DAC_ERR_MSK		 0x00000002

#define TIMEOUT		1000

typedef union 
      {
		    int ArrayOut[31];
  struct {  
  		int	WP_reg;        	//e. PLC output voltage
			int WP_sin;				  //r. сигнал поиска СРП - синус 250 Гц
			int	WP_pll;         //r. выход XOR ФД контура СРП
		  int HF_reg;			  	//e. HFO output voltage
			
			int HF_dif;

			int WP_Phase_Det_Array[8]; //e. arrays for "worms" output //r. массивы для вывода "червячков"
			int WP_sin_Array[8];
			int	WP_scope1, WP_scope2; 	//e. temporary variables for Rate3 monitoring //r. временные переменные для наблюдения в Rate3
		 
	   uint32_t F_ras;          //e. really output frequency, divided by 16  (for transmission) 		    
	   uint32_t L_Vibro;		//e. period of oscillation of the dither drive //r. период колебания вибропривода
	   uint32_t T_Vibro;		//e. pulse width of the dither drive //r. длительность импульса вибропривода
	   uint32_t T_VB_pll;       //e. PD output of the frequency regulator of the dither drive  //r. выход ФД регулятора частоты вибропривода

			int PS_dif;
			int BINS_dif;
			int Cnt_Dif;
			int Cnt_Pls;
			int Cnt_Mns;
			int Tmp_Out[6];

		__int64 SF_dif;
		 
		 } Str;	 
	   } OUTPUT;


typedef union 
      {
			int ArrayIn[3];
  struct {		  							
			int Tmp_in[2];
			int HF_out;	
			int WP_sel;		       	
		 }StrIn;
	   } INPUT; 

extern INPUT Input;
extern OUTPUT Output;

void DAC_ADC_Exchange_Init(void);
void DAC_ADC_Exchange(void);
void ADC_Input(void);

void clc_HFO(void);

int  clc_WP_sin(void);
void clc_PLC(void);
void init_PLC(void);

void clc_Pulses(void);
void SOI_Init(void);

void VibroDither_SwitchOn(void);
void VibroDither_SwitchOff(void);
void VibroDither_Set(void);
void DACInit(void);
void DAC_Output(int);
void  clc_ThermoSensors(void);

void Out_G_photo(unsigned, unsigned);
void G_Photo_Init( void );
void G_Photo_Exchange(void);

//endof file

#endif // InputOutput_H

