#include "Global.h"

#define		HFO_NEG_MIN			8738	// -4.5 V
#define		HFO_NEG_MAX			25122	// -10.5 V
#define		HFO_POZ_MIN			-32221	// +10.5 V
#define		HFO_POZ_MAX			-15837 	// +4.5 V

/******************************************************************************
** Function name:		clc_HFO
**
** Descriptions: Procedure of the HFO regulator
**
** parameters:	None
** Returned value:	None
**
******************************************************************************/
void clc_HFO() // --- HFO regulator ---
{

    static int  hf_reg = 0; //r. значение интегратора в контуре ГВЧ


    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //r. фильтрация выхода ампл. детектора перед передачей в контур ГВЧ
    /*int HFO_MovAverFilt (int Input)
    {
    static __int64 smooth_HF = 0;

    static  int buffer_HF[BUF_SIZE];

    static unsigned i_HF = 0;

    smooth_HF        -=  buffer_HF[i_HF];
    buffer_HF[i_HF]   =  Input;
    smooth_HF        +=  Input;

     i_HF++;
    i_HF &= (BUF_SIZE-1);

    return (smooth_HF>>22);	//shift on additional 6 bits for smoothing 2^6 = 64
    }*/


//                                                       HFO_SHIFT - число разрядов дробной части в 32-хбитовой переменной hf_reg32
    Input.StrIn.HF_out = HFO_MovAverFilt(Input.StrIn.HF_out<<HFO_SHIFT);
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    Output.Str.HF_dif = L_sub(Device_blk.Str.HF_ref, Input.StrIn.HF_out); // HF_dif	= HF_out - Device_blk.Str.HF_ref;

    if ( loop_is_closed(HF_REG_ON) ) {	//e. the regulator loop is closed //r. контур замкнут
        //                                           коэффициент передачи
        hf_reg = L_mac( hf_reg, Output.Str.HF_dif, Device_blk.Str.HF_scl ); // hf_reg32 += HFO_error * Device_blk.Str.HF_scl;
        Saturation(hf_reg, Device_blk.Str.HF_max << HFO_SHIFT, Device_blk.Str.HF_min << HFO_SHIFT); //e. checking range //r. проверка диапазона if (Uin > UpSat) Uin = UpSat;	if (Uin < DownSat) Uin = DownSat;
        Output.Str.HF_reg = (hf_reg >> HFO_SHIFT); 	// Output.Str.HF_reg - HFO output voltage
    } else {
        hf_reg = Output.Str.HF_reg << HFO_SHIFT;	 //r. интегратору присваиваем предыдущее значение HF_reg
    }

    // cyclic built-in test
    if (!(((Output.Str.HF_reg < HFO_NEG_MAX)&&(Output.Str.HF_reg > HFO_NEG_MIN))||((Output.Str.HF_reg < HFO_POZ_MAX) && (Output.Str.HF_reg > HFO_POZ_MIN)))) {
        Valid_Data |= HFO_VOLT_ERROR;
    }
} // clc_HFO


