#ifndef DEVICE
#define DEVICE

//e. constants for the piecewise-linear thermocompensation //r. константы для кусочно-линейной термокомпенсации
#define 	TERMO_FUNC_SIZE		14 	//e. amount of the points of the table function of thermocompensation //r. количество точек табличной функции термокомпенсации
#define 	MAX_ORDER			9   //e. maximal value of order for the thermocompensation coefficients //r. максимальная величина порядка для коэффициентов термокомпенсации
#define 	TSENS_NUMB			4   //e. number of the temperature sensor used for the thermocompensation //r. номер термодатчика, используемого для компенсации

typedef enum _TERMO_MODE { //e. thermocompensation modes //r. режимы работы термокомпенсации
    TERMO_OFF,						//e. thermocompensation is switched off  //r. термокомпенсация выключена
    TERMO_ON,						//e. thermocompensation is switched on  //r. термокомпенсация включена
    TERMO_ON_NUMB_OFF,				//e. thermocompensation is switched on, number resets (debug mode) //r. термокомпенсация включена, число зануляется (отладочный режим)
    TERMO_ON_STATIC_ONLY,			//e. only static thermocompensation is switched on  //r. включена только статическая термокомпенсация
    TERMO_ON_DYNAMIC_ONLY,			//e. only dynamic thermocompensation is switched on  //r. включена только динамическая термокомпенсация
    TERMO_ON_STATIC_ONLY_NUMB_OFF,	//e. static thermocompensation is switched on, number resets (debug mode) //r. статическая термокомпенсациявключена, число зануляется (отладочный режим)
    TERMO_ON_DYNAMIC_ONLY_NUMB_OFF	//e. dynamic thermocompensation is switched on, number resets (debug mode) //r. динамическая термокомпенсациявключена, число зануляется (отладочный режим)
} TERMO_MODE;

typedef enum _WATCH_MODE { //e. variants of control points for scope //r. варианты контрольных точек для осциллографа
    VB_DELAY_MEANDER,			//e. the delayed on the VB_phs meander //r. задержанный меандр на величину VB_phs
    VB_PHASE_DETECTOR,			//e. output of the PD of the dither drive //r. выход фазового детектора виюропривода
    VB_PHASE_DETECTOR_1_SEC,	//e. output of integral of the PD of the dither drive for 1 Sec //r. выход интеграла ФД вибропривода за 1 сек
    VB_INTEGRATOR_40T,			//e. output of integral of the PD of the dither drive for 40 periods //r. выход интеграла ФД вибропривода за 40 периодов
    WP_PHASE_DETECTOR  			//e. output of the PD of the CPLC regulator //r. выход фазового детектора контура СРП
} WATCH_MODE;

//e. =====  device operation modes ================================================================ //r. ===== режимы работы прибора ================================================================
#define  DM_INT_10KHZ_LATCH				1		//e. mode of internal latch 10 kHz //r. режим внутренней защелки 10 кГц			
#define  DM_INT_LATCH_DELTA_PS			2
#define	 DM_INT_LATCH_DELTA_BINS		3
#define  DM_EXT_LATCH_DELTA_PS_PULSE	4		//e. mode of external latch with output of the Delta_PS command by pulse //r. режим внешней защелки с выдачей команды Delta_PS по импульсу
#define  DM_EXT_LATCH_DELTA_BINS_PULSE	6		//e. mode of external latch with output of the Delta_BINS command by pulse//r. режим внешней защелки с выдачей команды Delta_BINS по импульсу
#define  DM_EXT_LATCH_DELTA_SF_PULSE	7		//e. mode of Delta Scale factor //r. режим Delta_SF command

//e. *** the BLOCK of VARIABLES, LOADED from FLASH-memory ********************** //r. *** БЛОК ПЕРЕМЕННЫХ, ЗАГРУЖАЕМЫХ из FLASH-памяти **********************
//e. Address (parameter number in the block = 0..255 ) //r. Адрес (Номер параметра в блоке = 0..255)
typedef  union {
    int Array[171];
    struct {
        // Device_blk
        int     My_Addres;      //e. 0 - device own address //r.0 - собственный адрес устройства

        //e. =============== parameters of HFO regulator ===============    //r. =============== параметры контура ВЧ генератора накачки ===============
        int		  HF_ref;    		  //e. 1 - value of the reference //r.  1 - значение опоры
        int     HF_scl;         //e. 2 - the gain factor (1.15)    //r. 2 - коэффициент передачи (1.15)
        int     HF_min;         //r.  3 - минимум выходного значения на ЦАПе регулятора (соответствует максим. напряжению на ГВЧ)
        int     HF_max;         //e. 4 - maximum of the output value on the regulator DAC (appropriate to minimal voltage on the HFO) //r.  4 - максимум выходного значения на ЦАПе регулятора (соответствует миним. напряжению на ГВЧ)

        //e. =============== parameters of the regulator of the DS power regulator ========== //r. =============== параметры контура регулирования мощности ДУП ==========
        int     RI_ref;         //e. 5 - value of the reference //r.  5 - значение опоры
        int     RI_scl;         //e. 6 - the gain factor (1.15) //r.  6 - коэффициент передачи (1.15)

        //e. =============== parameters of the CPLC regulator ===== //r. =============== параметры контура стабилизации рабочего периметра (СРП) =====
        int     WP_ref;         //e. 7 -  value of the reference //r.  7 - значение опоры
        int     WP_scl;         //e. 8 - the gain factor (1.15) //r. 8 - коэффициент передачи (1.15)
        int     WP_mdy;         //e. 9 - value of the reset delay //r. 9 - значение задержки сброса
        int     WP_rup;         //e. 10 - upper value of DAC adjustment (appropriate to minimal voltage on the heater) //r. 10 - верхнее значение регулировки ЦАП (соответствует миним. напряжению на нагревателе)
        int     WP_rdw;         //e. 11 - lower value of the DAC adjustment (appropriate to maximal voltage on the heater) //r. 11 - верхнее значение регулировки ЦАП (соответствует максим. напряжению на нагревателе)

        //e. =============== parameters of the dither drive regulator of the GLD ==================== //r. =============== параметры контура вибропривода ГЛД ====================
        int     VB_phs;         //e. 12 - the phase delay parameter of the dither drive PLL //r.  12 - параметр Phase_зад. СРЧ вибропривода
        int     VB_scl;         //e. 13 - the gain factor (1.15) of the dither drive PLL  //r. 13 - коэффициент передачи (1.15) СРЧ вибропривода
        unsigned int VB_N;          //e. 14 - divider for dither drive period (defines dither period) //r. 14 - коэфф.деления N вибропривода (период колебаний) ВП
        unsigned int VB_Nmin;        //e. 15 - minimum of the output value of the oscillation period regulator //r. 15 - минимум выходного значения регулятора периода
        unsigned int VB_Nmax;        //e. 16 - maximum of the output value of the oscillation period regulator //r. 16 - максимум выходного значения регулятора периода

        int     VB_Fdf_Hi;      //e. 17 - adjusted output frequency (H) //r. 17 - заданная частота расщепления (H)
        unsigned int VB_Fdf_Lo;      //e. 18 - (L) (double precision) //r. 18 - (L) (двойная точность)

        int     VB_Fsc;         //e. 19 - the gain factor of the frequency regulator //r. 19 - коэффициент передачи регулятора частоты расщепления
        unsigned int VB_Tmin;        //e. 20 - the gain factor of the frequency regulator //r. 19 - коэффициент передачи регулятора частоты расщепления
        unsigned int VB_Tmax;        //e. 21 - maximum of the output value of the regulator //r. 21 - максимум выходного значения регулятора Tau
        unsigned int VB_tau;         //e. 22 - pulse width of the dither drive (without noise)//r. 22 - длительность импульса вибропривода (до ошумления)
        int     VBN_Tzd;        //e. 23 - adjusted noise period //r. 23 - заданный период ошумления
        int     VBN_Ran;        //e. 24 - range of the random component of noise //r. 24 - диапазон случайной составляющей ошумления VBN_Tsl
        int     VBN_k;          //e. 25 - adjusted noise constant //r. 25 - заданная константа ошумления

        //e. =============== parameters of processing of accurate data ============= //r. =============== параметры обработки точностной информации =============
        int     PI_Fsc; //_        //e.  26 - the S_ds scale parameter //r.  26 - масштабный коэффициент Sдуп
        int     PI_Fb0; //_        //e.  27 - the B_ds zero shift of the DS //r.  27 - смещение нуля ДУПа Bдуп
        int     PI_scl; //_        //e.  28 - the Scale scale coefficient of the gyro //r.  28 - масштабный коэфф. гироскопа Scale
        int     PI_bia; //_        //e.  29 - the Bias zero shift of the gyro //r.  29 - смещение нуля гироскопа Bias

        //e. ===============  coefficients of the temperature correction ================= //r. ===============  коэффициенты температурной коррекции =================
        int     PI_a0; //_         //  30
        int     PI_a1; //_         //  31
        int     PI_a2; //_         //  32
        int     PI_a3; //_         //  33
        int     PI_a4; //_         //  34
        int     PI_a5; //_         //  35
        int     PI_a6; //_         //  36
        int     PI_b1; //_         //  37
        int     PI_b2; //_         //  38
        int     PI_b3; //_         //  39
        int     PI_b4; //_         //  40
        int     PI_b5; //_         //  41
        int     PI_b6; //_         //  42

        //e. =============== parameters of normalization of the temperature sensors  ============= //r. =============== параметры нормировки датчиков температуры =============

        int     Tmp_bias[6]; //_  //e. 43 - an array of shifts of the 0..5 temperature sensors //r. 43 - массив сдвигов температурных датчиков 0..5
        int     Tmp_scal[6]; //_  //e. 49 - an array of the scale coefficients of temperature sensors//r.  49 - массив масштабных к-тов температурных датчиков
        int     WP_reset;       //e. 55 - initial position of the CPLC regulator (after reset)  //r.  55 - исходное положение регулятора СРП (после сброса)

        //e. ================ gain factor of photodetector channels =========== //r. ================ к-т усиления каналов фотоприемника ===========
        unsigned int	Gain_Ph_A;		//e. 56 - initial gain factor of the A channel of photodetector //r.	56 - начальный к-т усиления канала А фотоприемника
        unsigned int	Gain_Ph_B;		//e. 57 - initial gain factor of the B channel of photodetector //r. 57 - начальный к-т усиления канала B фотоприемника

        //e. =============== switch of the source of loading GLD variables block === //r. =============== переключатель источника загрузки блока переменных ГЛД (галочка в настороечной программе)
        int		Header_Word;			//e. 58 - flash sector validity header  //r. 58 - заголовок-ключ к индикатору источника загрузки
        int		LoadFlash_enable;		//e. 59 - source loading flag: 1 - load from the flash //r. 59 - признак источника загрузки: 1 - грузиться из flesh
        //e. 0 - load default parameters (factory)  //r. 0 - грузить параметры по умолчанию (заводские)
        unsigned int Device_SerialNumber;		//e. 60 - serial number of the device //r. 60 - серийный номер прибора
        int     Reserved0;       //e. 61 - not used
        TERMO_MODE	TermoMode;	//e  62 - device operation mode (with thermocompenstion, without it, debug )//r.  62 - режим работы прибора (с термокомпенсацией, без нее или отладка)
//e. addition for the piecewise-linear termocorrection //r. добавление для кусочно-линейной термокоррекции
        int 	TemperInt[TERMO_FUNC_SIZE];	//e. 63
        float 	TermoFunc[TERMO_FUNC_SIZE];	//e. 77
        int     WP_reset2;       //e. 91 - voltages of CPLC regulator reset at cooling //r.  xx - напряжения обнуления контура СРП при охлаждении
        //e. parameters setting termocompensation parameters in dynamics (at heating and cooling) //r. параметры, задающие параметры термокомпенсации в динамике (при нагреве и охлаждении)
        float	Reserved1; //e. 92 - not used
        float	Reserved2; //e. 93 - not used
        int		K_vb_tu; 			//e. 94 - slope of dependence of the VB_N division factor from temperature (as though Hz/degree, but in relative units ) //r. крутизна зависимости коэффициента деления VB_N от температуры (как бы Гц/градус, но в у.е.)
        int		TemperNormal; 		//e. 95 -temperature for which the VB_N division factor of the dither drive is set //r. температура, для которой задан коэффициент деления вибропривода VB_N
        int		K_WP_rst_heating; 	//r. 96 - крутизна зависимости напряжения обнуления при нагревании от температуры (как бы вольт/градус, но в у.е. ЦАП и термодатчиков )
        int		K_WP_rst_cooling; 	//e. 97 - slope of dependence of a reset voltage at cooling from temperature (as though Volt/degree, but in relative units of DAC and temperature sensors)  //r. крутизна зависимости напряжения обнуления при охлаждении от температуры (как бы вольт/градус, но в у.е. ЦАП и термодатчиков )
        int		WP_transition_step; //e. 98 - step of change of a heater voltage at resetting //r. шаг изменения напряжения нагревателя при выполнении обнуления
        int		Reserved3; // e. 99 -not used
        int     HF_scl_2;         //r. 100 -  коэффициент передачи (1.15) контура ГВЧ при обнулении
        int 	TemperIntDyn[TERMO_FUNC_SIZE]; //e. 114 -
        float   ThermoHeatDelta[TERMO_FUNC_SIZE]; //e. 128 -
        int     DeltaTempRecalc;   //r. 129 - температурный интервал пересчета динамич. компенсации (в у.е.) //e. temperature delta for dynamic thermocompensation recalculation(in relative units)
        int 	TemperCoolIntDyn[TERMO_FUNC_SIZE]; // e. 143 -
        float   ThermoCoolDelta[TERMO_FUNC_SIZE];  //e. 157 -
    } Str;
} TDEVICE_BLK;











//e. ************ end of the BLOCK of VARIABLES, LOADED from FLASH-memory ************ //r. ************ конец блока загружаемых из флэш-памяти параметров ГЛД ************
extern 	TDEVICE_BLK Device_blk; //e. the BLOCK of VARIABLES, LOADED from FLASH-memory //r. БЛОК ПЕРЕМЕННЫХ, ЗАГРУЖАЕМЫХ из FLASH-памяти

extern 		 int Device_Mode;
extern 	unsigned Valid_Data;

extern	unsigned ser_num;

extern		 int VB_Nmin0;  //r. минимум  выходного значения регулятора периода для температуры Device_blk.TemperNormal
extern		 int VB_Nmax0;  //r. максимум выходного значения регулятора периода для температуры Device_blk.TemperNormal

extern  unsigned BIT_number;
extern  unsigned Is_BIT;

extern	unsigned start_Rq;       //r. запрос на запуск прибора
extern	unsigned stop_Rq;        //r. запрос на останов прибора
extern	unsigned pulse_Rq;       //r. запрос на поджиг лазера

//r. *** Приборные параметры по умолчанию ***
#define	DEVICE_SN			1		       //r. серийный номер прибора = 01
#define	My_Addres_const		0	     //r.   - собственный адрес устройства 

//r. ====== параметры контура ВЧ генератора накачки ===============

#define	HF_REF_CONST	15080	   //r.  1 - значение опоры  
#define	HF_SCL_CONST	1	       //r. 2 - коэффициент передачи (1.15)                              
#define	HF_MIN_CONST	-32668   //r.  3 - минимум выходного значения на ЦАПе регулятора (соответствует максим. напряжению на ГВЧ)
#define	HF_MAX_CONST    -17379 //r.  4 - максимум выходного значения на ЦАПе регулятора (соответствует миним. напряжению на ГВЧ)
#define	HFO_SHIFT		16		     //r. число разрядов дробной части в 32-хбитовой переменной hf_reg32

//r. ====== параметры контура стабилизации рабочего периметра (СРП) =====

#define	WP_REF_CONST	5         //r.  7 - значение опоры                                                  
#define	WP_SCL_CONST	5	        //r. 8 - коэффициент передачи (1.15)
#define	WP_MDY_CONST	30		    //r. 9 - значение задержки сброса                                        
#define	WP_RUP_CONST	31936   	//r. 10 - нижнее  значение регулировки ЦАП (соответствует миним. напряжению на нагревателе)                                     
#define	WP_RDW_CONST	11801	    //r. 11 - верхнее значение регулировки ЦАП (соответствует максим. напряжению на нагревателе)


//r. =============== параметры контура вибропривода ГЛД ====================

#define	VB_PHS_CONST	4     	//r.  12 - параметр Phase_зад. СРЧ вибропривода        
#define	VB_SCL_CONST	1024	  //r. 13 - коэффициент передачи (1.15) СРЧ вибропривода
#define	T_VIB_START     16600	//r. 14 - коэфф.деления N вибропривода (период колебаний) ВП
//r. _VB_N начальный период колебаний вибропривода (406Hz-18916, 17067 - 450Hz)
#define	T_VIB_DELTA	    1000	//r. диапазон изменения периода колебаний вибропривода (~ +/- 10 Hz)

#define	VB_NMIN_CONST   12080	    //r. 15 - минимум выходного значения регулятора периода 
#define	VB_NMAX_CONST   64000	    //r. 16 - максимум выходного значения регулятора периода
#define	VB_FDF_HI_CONST	3	        //r. 17 - заданная частота расщепления (H)                     
#define	VB_FDF_LO_CONST	0  	    	//r. 18 - (L) (двойная точность)                      
#define	VB_FSC_CONST	-2000	      //r. 19 - коэффициент передачи регулятора частоты расщепления                  
#define	VB_TMIN_CONST	100	        //r. 20 - минимум выходного значения регулятора Tau                           
#define	VB_TMAX_CONST	10022	      //r. 21 - максимум выходного значения регулятора Tau                  
#define	L_VIB_START      5120	    //r. 22 - длительность импульса вибропривода (до ошумления)
//r. _VB_tau начальная длительность импульса вибропривода

#define	VBN_TZD_CONST	500     //r. 23 - заданный период ошумления (константа пользователя)
#define	VBN_RAN_CONST	400     //r. 24 - диапазон случайной составляющей ошумления VBN_Tsl                               
#define	VBN_K_CONST  	7000	//r. 25 - заданная константа ошумления (константа пользователя)

//r. =============== параметры контура регулирования мощности ДУП ==========
#define	RI_REF_CONST	25600	//r.  5 - значение опоры                                                
#define	RI_SCL_CONST	0	    //r.  6 - коэффициент передачи (1.15)


//r. =============== параметры обработки точностной информации =============
#define	PI_FSC_CONST	128	    //r.  26 - масштабный коэффициент Sдуп
#define	PI_FB0_CONST	0	    //r.  27 - смещение нуля ДУПа Bдуп
#define	PI_SCL_CONST	256	    //r.  28 - масштабный коэфф. гироскопа Scale
#define	PI_BIA_CONST	0	    //r.  29 - смещение нуля гироскопа Bias

//r. ===============  коэффициенты температурной коррекции =================
#define	PI_A0_CONST		0	//  30
#define	PI_A1_CONST		0	//  31
#define	PI_A2_CONST		0	//  32
#define	PI_A3_CONST		0	//  33 
#define	PI_A4_CONST		0	//  34
#define	PI_A5_CONST		0	//  35
#define	PI_A6_CONST		0	//  36
#define	PI_B1_CONST		0	//  37
#define	PI_B2_CONST		0	//  38
#define	PI_B3_CONST		0	//  39
#define	PI_B4_CONST		0	//  40
#define	PI_B5_CONST		0	//  41
#define	PI_B6_CONST		0	//  42

#define TMP_SCALE		0x4000 // 43 - 54  Tmp_bias[6]; Tmp_scal[6]
#define TMP_BIAS		0
#define	WP_RESET_CONST 7360	// 55
#define WP_RESET2_CONST 29216
#define WP_TRANS_STEP	32767
//r. ================ начальный к-т усиления каналов фотоприемника ===========
#define	G_PHOTO_STRA	60     // 56 
#define	G_PHOTO_STRB  	60		// 57

//r. =============== переключатель источника загрузки блока переменных ГЛД ===
#define HEADER_WORD_CONST	0x55aa	//r. 58 - заголовок-ключ к индикатору источника загрузки

#define  DITHER_REG_PERIOD		40	 //r. период регулирования виброприода (в периодах вибропривода)

#define  PLC_RESET_THRESHOLD 	(-3276)  //r. соответствует напряжению +1.2 вольта	

//r. мин.допустимая частота расщепления, при кот. данные считаются достоверными
#define		F_RAS_MIN	    10000 	//r.  минимальная частота расщепления при старте
#define		F_OUT_MIN		(5000>>4)  	//   5000 Гц / 16
#define		F_OUT_NORM		(70000>>4)  	//  90000 Гц / 16
#define		F_OUT_MAX		(300000>>4) 	// 300000 Гц / 16

#define		Set_LightUp		LPC_GPIO0->FIOSET = (1<<4)	//set light up signal
#define		Reset_LightUp	LPC_GPIO0->FIOCLR = (1<<4)	//reset light up signal

//r. константы для кусочно-линейной термокомпенсации
#define 	TERMO_FUNC_SIZE		14 	 //r. количество точек табличной функции термокомпенсации
#define 	MAX_ORDER			9    //r. максимальная величина порядка для коэффициентов термокомпенсации
#define 	TSENS_NUMB			4   //r. номер термодатчика, используемого для компенсации

#define	    VALID_START_4SEC		3 //r. время после старта, когда температура стала достоверной

#define		N_START_MAX     	1 // 4        //r. число попыток запуска прибора
#define		LIGHT_UP_PULSE_WDTH 5000 //1000 //e. width of light-up pulse = 100 msec
#define		LIGHT_UP_PAUSE		1000          //e. pause after light-up = 100 msec
#define		LIGHT_UP_POLLING	10000         //e. time of waiting laser generation = 1 sec

// Status word errors bits
#define		OUT_FREQ_ERROR		0x8000
#define		DITH_FREQ_ERROR		0x4000
#define		HFO_VOLT_ERROR		0x2000
#define		THERMO_RANGE_ERROR	0x1000
#define		THERMO_DIFF_ERROR	0x0800

#define		TS_MIN				-2500 	// minimal temperature for our thermal sensors
#define		TS_MAX				+13000  // maximal temperature for our thermal sensors
#define		TS_DIFF_MAX			1300	// maximal difference between 2 thermal sensors

#define		HFO_NEG_MIN			8738	// -4.5 V
#define		HFO_NEG_MAX			25122	// -10.5 V
#define		HFO_POZ_MIN			-32221	// +10.5 V
#define		HFO_POZ_MAX			-15837 	// +4.5 V

//e. ================ bits of the main register (_RgConA) of GLD control ==============
//r. ================ биты основного регистра управления GLD (_RgConA) ===============
//e. ================ (bits of the status register) ============================
//r. ================ (они же - биты регистра состояния) ============================
#define  LASER_ON        0x0001  		 //r. вкл./выкл. генерацию лазера
#define  HF_REG_ON       0x0002  		 //r. вкл./выкл. контур ГВЧ  
#define  RI_REG_ON       0x0004  		 //r. вкл./выкл. контур мощности ДУП   
#define  WP_REG_ON       0x0008  	   //r. маска вкл./выкл. контура СРП  
#define  WP_SIN_ON       0x0010  		 //r. вкл./выкл. поисковый сигнал СРП  
#define  VB_TAU_ON       0x0020  		 //r. вкл./выкл. контур амплитуды виброривода 
#define  VB_FREQ_ON      0x0040  		 //r. вкл./выкл. контур частоты вибропривода
#define  GLD_ON          0x0080  		 //r. вкл./выкл. весь ГЛД

// Status word errors bits
#define		OUT_FREQ_ERROR		0x8000
#define		DITH_FREQ_ERROR		0x4000
#define		HFO_VOLT_ERROR		0x2000
#define		THERMO_RANGE_ERROR	0x1000
#define		THERMO_DIFF_ERROR	0x0800

#define loop_is_closed(loop_bit) 	((RgConA & (loop_bit)) == loop_bit)
#define close_loop(loop_bit) 		RgConA |= loop_bit
#define open_loop(loop_bit) 		RgConA &= ~(loop_bit)
//r. выключить все контура регулирования
#define open_all_loops()			RgConA   = 0
#define close_all_loops()			RgConA   = 0xFFFF

extern unsigned    SRgR;             //r.системного регистра режима платы ADSP

extern unsigned 	RgConA;            //r. основной регистр управления устройства
extern unsigned 	RgConB;            //r. дополнительный регистр управления
//extern unsigned		Copy_e5_RgR;     //r. копия регистра режима платы E5
//extern unsigned		Copy_e5_RgRA;    //r. копия дополнительного регистра режима E5

void contrl_GLD(void);
#endif



