#ifndef VIBRO_H
#define VIBRO_H

/*
#define  SetV1 LPC_GPIO1->FIOSET = (1<<25);
#define  ClrV1 LPC_GPIO1->FIOCLR = (1<<25);
#define  SetV2 LPC_GPIO1->FIOSET = (1<<28);
#define  ClrV2 LPC_GPIO1->FIOCLR = (1<<28);
*/
#define ClrV1  LPC_GPIO1->FIOSET=(1<<25);
#define SetV1 LPC_GPIO1->FIOCLR = (1<<25);

#define  ClrV2 LPC_GPIO1->FIOSET = (1<<28);
#define  SetV2 LPC_GPIO1->FIOCLR = (1<<28);

#define  LoopOn  LPC_GPIO1->FIOSET  = (1<<30);
#define  LoopOff LPC_GPIO1->FIOCLR  = (1<<30);
#define  StartV1  0
#define  StartV2 15
#define  TIME_INTERVAL	(7812)


struct MAIN	{

    unsigned int RgConA;
    unsigned int RgConB;


    unsigned int Frq;       // Непосредственное значение частоты для таймера.
    unsigned int FrqHZ;     // Частота в Гц.
    unsigned int FrqRate;   // Разброс частот при ошумлении.
    unsigned int FrqMin;    // Минимальное значение ошумленной частоты.
    unsigned int FrqOld;    // Значение частоты за прошлый такт.

    unsigned int Amp;
    unsigned int AmpL;
    unsigned int AmpT;
    unsigned int AmpPer;
    unsigned int AmpPerDel;//0-100%
    unsigned int AmpN1;
    unsigned int AmpN2;
    unsigned int AmpMin;
    unsigned int AmpTD;

    unsigned int CMD_In;
    unsigned int SOC_Out;
    unsigned int My_Addres;
    unsigned int GLD_Serial;
    unsigned int CRC;
    unsigned int Firmware_Version;
    unsigned int RsErrLine;

    unsigned int Cnt_Pls;
    unsigned int Cnt_Mns;
    unsigned int Cnt_Dif;
    unsigned int T_Vib;
    unsigned int F_ras;

    unsigned int PinReg;     //          bit5             bit4                  bit 3                 bit1                 bit0
    unsigned int PinRegOld;  //    || светодиод || состояние поджига  || состояние подсветки || состояние вибро 2 || состояние вибро 1 ||
    #define  PinRegBitD  	1<<8
    #define  PinRegBitL  	1<<4
    #define  PinRegBit_1V  	1<<1
    #define  PinRegBit_2V  	1<<2




    unsigned int Discharg;   //   последовательность бит харрактеризующая ворму сигнала поджига.
	    #define  StartDischarg         0x00000005
 

    unsigned int BackLight;  //   последовательность бит харрактеризующая ворму сигнала подсветки.


    
};
extern struct MAIN Main;

extern void init_Vibro ();
extern void cheng(void);
extern void Noise(void);
extern void VibroOut(void);

extern int Pulse_midl ;
extern struct VIBRO Vib;
extern int PulseHalf;
extern  int CuruAngle;
extern unsigned int FrecTemp;
#endif

