/**--------------File Info---------------------------------------------------------------------------------
** File name:           el_lin.h
** Last modified Date:  2011-08-22
** Last Version:        V1.00
** Descriptions:
**
**--------------------------------------------------------------------------------------------------------
** Created by:          Electrooptika incor.
** Created date:        2011-08-22
** Version:             V1.00
**
**--------------------------------------------------------------------------------------------------------
*********************************************************************************************************/
#ifndef __DMA_H
#define __DMA_H



#define  STRT_ERR        0x0080          //e. error of the start bit //r. ошибка старт-бита  
#define  STOP_ERR        0x0040          //e. error of the stop bit //r. ошибка стоп-бита  
#define  SIZE_ERR        0x0004          //e. size of the received data packet mismatches the agreement //r. размер принятого пакета не соответствует соглашению  
#define  LCC_ERR         0x0002          //e. checksum has not coincided //r. не совпала контрольная сумма
#define  NO_CMD_ERR      0x0100          //e. in the received packet there is no attribute of command //r. в принятом пакете нет признака команды  
#define  CODE_ERR        0x0200          //e. unknown code of a command //r. неизвестный код команды  
#define  MODE_ERR        0x0400          //e. code of a command mismatches a current mode //r. код команды не соответствует текущему режиму  
#define  PARAM_ERR       0x0800          //e. parameters of a command was set incorrectly //r. неверно заданные параметры команды  
#define  MAXSIZE_ERR     0x1000          //e. receiver buffer overflow //r. переполнение буфера приемника  
#define  ADDR_ERR        0x2000          //e. incorrect address of the device //r. неверный адрес устройства  
#define  READ_ERR        0x4000          //e. stop of link because of untimely data read //r. останов связи несвоевременным чтением данных  
#define  WASQ_ERR        0x8000          //e. error of waiting of authentic answer //r. ошибка ожидания достоверного ответа  

#define  Trm_En_Rd       0x0080          //e. a mask of permission/readiness of transmitter of the 2 line //r. маска разрешения/готовности передатчика линии 2  
#define  Rcv_Rdy         0x0040          //e. a mask of the readiness bit of the receiver //r. маска бита готовности приемника  
#define  Rcv_Ferr        0x0020          //e. a mask of the "format error" bit //r. маска бита "ошибка формата" 
#define  Rcv_Tout        0x0010          //e. a mask of the "time-out" bit //r. маска бита "тайм-аут" 
#define  Rcv_Rful        0x0008          //e. a mask of the "stack is full" bit //r. маска бита "стек полон"


#define FIFOs_En			0x00000001
#define RX_FIFO_Reset		0x00000002
#define TX_FIFO_Reset		0x00000004
#define DMA_Mode_UART		0x00000008
#define RX_TrigLvl_1		0x00000000
#define RX_TrigLvl_4		0x00000040
#define RX_TrigLvl_8		0x00000080
#define RX_TrigLvl_14		0x000000C0

#define	word_length_8		0x00000003

#define one_stop_bit	    0x00000000

#define no_parity			0x00000000

#define back_trans_dis	    0x00000000

#define DLAB_access			0x00000080

#define TRANS_SHIFT_BUF_EMPTY		0x00000040
#define DMA_BUSY					0x00020000
#define RecievBufEmpty		0x00000001
#define DIS_ALL_INT			0x00000000
#define RBR_IntEnabl		0x00000001
/* Second half of the second RAM is used for GPDMA operation. */

#define DMA_UART0_TX		8
#define DMA_UART0_RX		9
#define DMA_UART1_TX		10
#define DMA_UART1_RX		11
#define DMA_UART2_TX		12
#define DMA_UART2_RX		13
#define DMA_UART3_TX		14
#define DMA_UART3_RX		15

#define DMA_MEMORY			0
#define SrcDMA_UART0_RX		DMA_UART0_RX << 1
#define SrcDMA_UART0_TX		DMA_UART0_TX << 1
#define SrcDMA_UART1_TX		DMA_UART1_TX << 1
#define DstDMA_UART0_TX		DMA_UART0_TX << 6
#define DstDMA_UART1_TX		DMA_UART1_TX << 6
#define DstDMA_UART0_RX		DMA_UART0_RX << 6
#define SrcDMA_UART1_RX		DMA_UART1_RX << 1
#define DstDMA_UART1_RX		DMA_UART1_RX << 6

/* UART0 TX and RX */
#define UART0_DMA_TX_SRC	0x2007C800		/* starting addr of DATA register in UART0 */
#define UART0_DMA_TX_DST	LPC_UART0_BASE
#define UART0_DMA_RX_SRC	LPC_UART0_BASE
#define UART0_DMA_RX_DST	0x2007C900

#define UART2_DMA_TX_DST	LPC_UART2_BASE
#define UART1_DMA_TX_DST	LPC_UART1_BASE

#define GPDMA_POWER_ON		0x20000000

#define UART_REQ			0x00000000

//To clear particular DMA TC-interrupts
#define DMA0_IntTCClear		0x00000001
#define DMA1_IntTCClear		0x00000002
#define DMA2_IntTCClear		0x00000004
#define DMA3_IntTCClear		0x00000008
#define DMA4_IntTCClear		0x00000010
#define DMA5_IntTCClear		0x00000020
#define DMA6_IntTCClear		0x00000040
#define DMA7_IntTCClear		0x00000080

//To clear particular DMA Error-interrupts
#define DMA0_IntErrClear	0x00000001
#define DMA1_IntErrClear	0x00000002
#define DMA2_IntErrClear	0x00000004
#define DMA3_IntErrClear	0x00000008
#define DMA4_IntErrClear	0x00000010
#define DMA5_IntErrClear	0x00000020
#define DMA6_IntErrClear	0x00000040
#define DMA7_IntErrClear	0x00000080
#define DMACH1_IntTCPend	0x00000002

#define DMA_ControllerEn	0x00000001

#define DMA_AHB_Little		0x00000000
#define DMA_AHB_Big			0x00000002

#define SrcBSize_1			0x00000000
#define SrcBSize_4			0x00001000
#define SrcBSize_8			0x00002000
#define SrcBSize_16			0x00003000
#define SrcBSize_32			0x00004000
#define SrcBSize_64			0x00005000
#define SrcBSize_128		0x00006000
#define SrcBSize_256		0x00007000

#define DstBSize_1			0x00000000
#define DstBSize_4			0x00008000
#define DstBSize_8			0x00010000
#define DstBSize_16			0x00018000
#define DstBSize_32			0x00020000
#define DstBSize_64			0x00028000
#define DstBSize_128		0x00030000
#define DstBSize_256		0x00038000

#define SrcWidth_8b			0x00000000
#define SrcWidth_16b		0x00020000
#define SrcWidth_32b		0x00040000

#define DstWidth_8b			0x00000000
#define DstWidth_16b		0x00200000
#define DstWidth_32b		0x00400000

#define SrcInc				0x04000000
#define SrcFixed			0x00000000

#define	DstInc				0x08000000
#define	DstFixed			0x00000000

#define TCIntEnabl			0x80000000
#define TCIntDisabl			0x00000000

#define DMAChannelEn		0x00000001
#define DMAChannelDis		0x00000000

#define CH2_ENABLED			0x00000004

#define DONtMaskTCInt		0x00008000
#define MaskTCInt			0x00000000
#define	DONtMaskErrInt		0x00004000
#define MaskErrInt			0x00000000

#define INT_DMA_Disabl		0x04000000
/* DMA mode */
#define M2M				0x00
#define M2P				0x01
#define P2M				0x02
#define P2P				0x03

#define Sp38400				0x00000
#define Sp115200			0x00010
#define Sp460800			0x00020
#define Sp921600			0x00030

extern unsigned int  trm_num_byt;
extern unsigned int  rcv_num_byt;
extern unsigned int  rcv_Rdy;
extern			char trm_buf[64];
extern			char rcv_buf[64];
extern 			char rcv_copy[64];
extern unsigned int  trm_cycl;
extern unsigned int  num_of_par;
extern	      void*  addr_param[16];
extern unsigned int  size_param[16];
extern unsigned int  trm_rate;
extern unsigned int  trm_cycl;
extern unsigned int  rcv_num_byt_old;
extern 			int  rcv_byt_copy;
extern unsigned int  trm_ena;
extern			int  cycl_phase;
extern unsigned int  line_err;
extern unsigned int  line_sts;
extern 			int  rx_buf_copy;
extern			char zeros;
extern unsigned int SystemCoreClock;

extern void DMA_Init(void);
extern void transm_DAT(void);
extern void Line_1_Rcv(void);

extern void UARTInit(void);
extern void UART1_Init(void);
//extern int UART0_SendByte(int);
extern int UART1_SendByte(int);
extern void UART_SwitchSpeed(unsigned);
extern void UART_DMA_Init(void);
extern void SystemCoreClockUpdate (void);

#endif /* end __DMA_H */

