#define SAMPLE_RATE   48000


#include "mbed.h"
#include "adc.h"
#include "PololuLedStrip.h"

PololuLedStrip ledStrip(p8);

#define LED_COUNT 60
rgb_color colors[LED_COUNT];

Serial pc(USBTX,USBRX);

//extern "C" void cr4_fft_256_stm32(void *pssOUT, void *pssIN, uint16_t Nbin);
extern "C" void fftR4(short *y, short *x, int N);

//use the LED as a bargraph
DigitalOut l1(LED1);
DigitalOut l2(LED2);
DigitalOut l3(LED3);
DigitalOut l4(LED4);

//set up a timer for timing FFT's
Timer timer;

//Used to change colour of LED strips
//int testX = 0;

//Set up filesystem so we can write some useful files

LocalFileSystem local("local");              
FILE *fp;

//Set up a global buffer for audio data so interrupt can access it
int Counter = 0;
int16_t Buffer[5000];
int16_t VoltageBuffer[5000];

//Initialise ADC to maximum SAMPLE_RATE and cclk divide set to 1
ADC adc(SAMPLE_RATE, 1);

int colourVoltage=0;



//Our interrupt handler for audio sampling
void sample_ADC(int chan, uint32_t value) {
    
   float s;
   s = adc.read(p20); 
   int16_t b = (s -2048)*16;
   Buffer[Counter] = b;
   
   Counter += 1;
    /* bar graph */
     
    int g = abs(s-2048);
    l1 = g > 0.1f*2048;
    l2 = g > 0.3f*2048;
    l3 = g > 0.6f*2048;
    l4 = g > 0.8f*2048;
}


    
    
    
    
int main() {
    
while (1){
    
    //Prepare for burst mode on all ADC pins and set up interrupt handler (using ADC library from Simon Blandford
    adc.append(sample_ADC);
    adc.startmode(0,0);
    adc.burst(1);
    adc.setup(p20,1);
    //introduce a delay as initial waveform has bias whilst decoupling cap charges
    wait(0.05);
    //start the interrupt and wait for about 4096 samples
    adc.interrupt_state(p20,1);
    wait(0.05);
    
        //Finsh up - Unset pin 20
        adc.interrupt_state(p20,0);
        adc.setup(p20,0);
        int actual_rate = adc.actual_sample_rate();
//now lets try mellen fft-------------------------
        timer.reset();
        timer.start();
        #define MN 1024 /*Number of points*/
        short mx[MN*2]; // input data 16 bit, 4 byte aligned  x0r,x0i,x1r,x1i,....
        short my[MN*2]; // output data 16 bit,4 byte aligned  y0r,y0i,y1r,y1i,....
        float mz[MN*2]; // to store the final result
        for (int i=0;i<MN*2;i++) mx[i]=0;
        for (int i=0;i<MN*2;i++) mz[i]=0;
        for (int i=0;i<MN;i=i+1)
            { mx[i*2]=Buffer[i];}
        //printf("Mellen set up took %i\n",timer.read_us());
        //call functions
        timer.reset();
        timer.start();
        fftR4(my, mx, MN);
        //printf("Mellen fft took %i\n",timer.read_us());
//FILE* mlog = fopen("/local/mellen.csv","w");
        
        //now write a CSV file to filesytem of frequency vs amplitude
        for (int i=0; i<MN; i=i+2)
        {
          //  fprintf(mlog, "%d: %d -> %d\n", i, mx[i], my[i]);
            //fprintf(mlog, "%d,%f\n", int(actual_rate/MN/2*i),sqrt(float(   (my[i]*my[i])  +(my[i+1]*my[i+1])     ) )   );          
        
        mz[i]=sqrt(float(   (my[i]*my[i])  +(my[i+1]*my[i+1])     ) ) ;
         //fprintf(mlog, "%f\n", mz[i]  );
        }
       
        
        // detect the change of input frequency ******************************
    float maxFreq=0;
    float max=0;
    for (int i=2;i<512;i=i+1){
           
        if(mz[i]>max){
            max = mz[i];
            maxFreq=i;
            }//end if
        
        }//end for
    //fprintf(mlog, "%d\n",maxFreq  );
    
    int maxVoltage=0;
    for (int i=0;i<512;i=i+1){
           
        if(mx[i]>maxVoltage){
            maxVoltage = mx[i];
           
            }//end if
        }//end for
    
pc.printf(" the max = %f\n",max );
pc.printf(" the maxFreq = %f\n",maxFreq );
pc.printf(" the colourValtage = %d\n", maxVoltage );


        /*for (int i = 0; i < LED_COUNT; i++){
        colors[i] = (rgb_color){ 0, 0, 0 };  
        } 
        
        if (maxFreq>60) maxFreq=60; // Limiting Length
        
         for (int i = 0; i < maxFreq; i++){
            colors[i] = (rgb_color){ abs(maxVoltage/11),abs(255-(maxVoltage/11)) ,abs(255-(maxVoltage/11)+50)  };
            }   
             ledStrip.write(colors, LED_COUNT);*/
            int actualFreq= (actual_rate/MN/2*maxFreq);
            pc.printf(" actualFreq = %d\n", actualFreq );
            
            
            //wait_ms(10);
            
            /*if (maxFreq>30){
            //testX=200;
            for (int i = 0; i < LED_COUNT; i++){
            colors[i] = (rgb_color){ 0, 20, 200 };
            }
            }

        if ((maxFreq>22)&&(maxFreq<30)){// if frequency bigger than 966Hz
            //testX= 10;
            for (int i = 0; i < LED_COUNT; i++){
            colors[i] = (rgb_color){ 250, 0, 0 };
            
            }
            }
        if (maxFreq<22){
            //testX=200;
            for (int i = 0; i < LED_COUNT; i++){
            colors[i] = (rgb_color){ 0, 250, 0 };
            }
            }*/

    
     
       
        
            
            
            //-----------
        
        
        //fclose(mlog);    
  Counter = 0;
        }// end while (1)
        
    
}