#include "mbed.h"
#include "PololuLedStrip.h"

extern "C" void fftR4(short *y, short *x, int N);

//***************Global Varity***************************
#define BUF_LEN 1024
#define SAMP_FREQ 48000
#define LED_COUNT 60
short samples[BUF_LEN];// store values from ADC
short mx[BUF_LEN*2];// input data i6bit 4 byte aligned x0r,xoi,x1r,x1i,....
short my[BUF_LEN*2];// output data 16bit 4byte aligned y0r,y0i, y1r,y1i,....
float spectrum[BUF_LEN/2]; // frequency spectrum 
float max1 = 0.0;
    float max2 = 0.0;
    float max3 = 0.0;
    float max4 = 0.0;
    float max5 = 0.0;
    int j1 = 0;
    int j2 = 0;
    int j3 = 0;
    int j4 = 0;
    int j5 = 0;
    int j11=0;
    int j22=0;
    int j33=0;
    int j44=0;
    int j55=0;
rgb_color colors[LED_COUNT];
//--------------End of Global Varity---------------------



//************** Port Configuration *********************
AnalogIn audio(p20);  // ADC pin must be biased at Vcc/2 using coupling capacitor and potential divider
BusOut leds (LED1,LED2,LED3,LED4);
PololuLedStrip ledStrip(p8);


//*** Debug***
Serial serial(USBTX,USBRX); //Real time debug USB port 
LocalFileSystem local("local");     // Create the local filesystem under the name "local"

//----------------- End of Port Configuration------------


// **************SubFunctions Define *******************
void initLED();
void updateSamples();
float magnitude (short y1, short y2);
void doFFT();
void ledBarGraph();
void calcPeakFrequency ();
void runLED();

//--------------- END of Sub Define---------------------


int main()
{
    leds = 15;
    wait (1.0);
    leds =0;
    initLED();
    
    while(1) {
        ledBarGraph();
        updateSamples();
        doFFT();
        calcPeakFrequency ();
        runLED();
        
        }// End while
    

        
}// End main

//********************SubFunction Implementation****************

void initLED(){
     for (int i = 0; i < 60; i++){
            colors[i] = (rgb_color){ 2,200,2  };
            }   
    
    ledStrip.write(colors, LED_COUNT);
    
    wait(1);
    for (int i = 0; i < 60; i++){
            colors[i] = (rgb_color){ 0,0,0 };
            }   
    
    ledStrip.write(colors, LED_COUNT);
    
    }







//--------------------------------------
void updateSamples (){
    
    for (int i=0; i< BUF_LEN; i++){
        samples[i]= (short) (audio.read_u16() - 0x8000);
        wait_us(1e6/SAMP_FREQ);
        
        }//End for
    
    }// End updateSamples
    
void doFFT(){
    //clear buffers 
    for (int i=0; i<BUF_LEN*2; i++){
        mx[i]=0;
        my[i]=0;
        }// end for
        
    for (int i =0; i<BUF_LEN;i++){
        mx[i*2]=samples[i];
        }// end for
        
        fftR4(my,mx,BUF_LEN); // call FFT routine 
        
        int j=0;// counter number of next for loop
    
    for (int i= 0;i< BUF_LEN; i+=2 ){
        spectrum[j]= magnitude (my[i],my[i+i]); // get magnitude of FFT output to get spectrum data
        j++;
        }
    
    }// End doFFT
    
 //---------------------------   
float magnitude (short y1, short y2){
    
     return sqrt(float (y1*y1+y2*y2));
    }
    
   //------------------------------------------ 
void calcPeakFrequency (){
    float max = 0.0;
    
    int frequency = 0;
    int j = 0;
     max1 = 0.0;
     max2 = 0.0;
     max3 = 0.0;
     max4 = 0.0;
     max5 = 0.0;
     j1 = 0;
     j2 = 0;
     j3 = 0;
     j4 = 0;
     j5 = 0;
    
    
    for (int i=0; i<BUF_LEN; i+=2) {  // loop through spectrum and look for maximum value
        if (spectrum[j] > max) {
            max = spectrum[j];
            frequency = int(SAMP_FREQ/BUF_LEN/2*i);
        }
        j++;
    }
    
    for (int i=0; i<101; i+=2) {  
        if (spectrum[j1] > max1) {
            max1 = spectrum[j1];
            j11=j1;
        }
        j1++;
    }
   
   for (int i=102; i<204; i+=2) {  
        if (spectrum[j2] > max2) {
            max2 = spectrum[j2];
            j22=j2;
        }
        j2++;
    }
    
    for (int i=205; i<306; i+=2) {  
        if (spectrum[j3] > max3) {
            max3 = spectrum[j3];
            j33=j3;
        }
        j3++;
    }
    
    for (int i=307; i<408; i+=2) {  
        if (spectrum[j4] > max4) {
            max4 = spectrum[j4];
            j44=j4;
        }
        j4++;
    }
    
    for (int i=408; i<511; i+=2) {  
        if (spectrum[j5] > max5) {
            max5 = spectrum[j5];
            j55=j5;
        }
        j5++;
    }
    serial.printf("frq=%d\n",frequency);
    //serial.printf("j11-j55 = %d,%d,%d,%d,%d\n",j11,j22,j33,j44,j55);
    
    }//End calcPeakFrequency 
 //-------------------------------------------------   
    void ledBarGraph()
{
    float rms = 0.0;  // initialse array
    for (int i = 0; i < BUF_LEN; i++) {
        rms+= samples[i]*samples[i];
    }
    // calc the sum of the squares
 
    rms/=BUF_LEN;     // get the mean
    rms = sqrt(rms);  // and root to get the RMS
    rms/= 16384.0;  // scale according to 16-bit signed maximum value
 
    // check value and update LEDs to show amplitude
    if (rms > 0.8) {
        leds = 15;
    } else if (rms > 0.6) {
        leds = 7;
    } else if (rms > 0.4) {
        leds = 3;
    } else if (rms > 0.2) {
        leds = 1;
    } else {
        leds = 0;
    }
 
    //serial.printf("RMS = %f\n",rms);
}//End void ledBarGraph

//-------------------------------------------



void runLED(){
    // clear the ledStrip
    for (int i = 0; i < LED_COUNT; i++){
        colors[i] = (rgb_color){ 0, 0, 0 };  
        } 
        
        //if ((maxFreq)>60) maxFreq=60; // Limiting Length
        
        // max1
         for (int i = 0; i < (j11/10); i++){
            colors[i] = (rgb_color){ 200,2,2  };
            }  
        
        //max2
        for (int i = 21; i > (j22/10); i--){
            colors[i] = (rgb_color){ 2,200,2  };
            }   
        
        //max3
        for (int i = 24; i < (j33/10); i++){
            colors[i] = (rgb_color){ 2,200,200  };
        }
        //max4
        for (int i = 45; i > (j44/10); i--){
            colors[i] = (rgb_color){ 100,2,200  };
        }
        //max5
        for (int i = 48; i < (j55/10); i++){
            colors[i] = (rgb_color){ 200,2,200  };
          }  
             
             ledStrip.write(colors, LED_COUNT);
    }






/*void runLED(){
    // clear the ledStrip
    for (int i = 0; i < LED_COUNT; i++){
        colors[i] = (rgb_color){ 0, 0, 0 };  
        } 
        
        //if ((maxFreq)>60) maxFreq=60; // Limiting Length
        
        // max1
         for (int i = 0; i < 9; i++){
            colors[i] = (rgb_color){ 200,2,2  };
            }  
        
        //max2
        for (int i = 21; i > 12; i--){
            colors[i] = (rgb_color){ 2,200,2  };
            }   
        
        //max3
        for (int i = 24; i < 33; i++){
            colors[i] = (rgb_color){ 2,200,200  };
        }
        //max4
        for (int i = 45; i > 36; i--){
            colors[i] = (rgb_color){ 100,2,200  };
        }
        //max5
        for (int i = 48; i < 57; i++){
            colors[i] = (rgb_color){ 200,2,200  };
          }  
             
             ledStrip.write(colors, LED_COUNT);
    }*/

/*void runLED(){
    // clear the ledStrip
    for (int i = 0; i < LED_COUNT; i++){
        colors[i] = (rgb_color){ 0, 0, 0 };  
        } 
        
        //if ((maxFreq)>60) maxFreq=60; // Limiting Length
        
        // max1
         for (int i = 0; i < (j11/10); i++){
            colors[i] = (rgb_color){ 200,2,2  };
            }  
        
        //max2
        for (int i = 21; i < (21-((j22-101)/10)); i--){
            colors[i] = (rgb_color){ 2,200,2  };
            }   
        
        //max3
        for (int i = 24; i < (24+((j33-204)/10)); i++){
            colors[i] = (rgb_color){ 2,200,200  };
        }
        //max4
        for (int i = 45; i < (45-((j44-306)/10)); i--){
            colors[i] = (rgb_color){ 100,2,200  };
        }
        //max5
        for (int i = 48; i < (48+((j55-408)/10)); i++){
            colors[i] = (rgb_color){ 200,2,200  };
          }  
             
             ledStrip.write(colors, LED_COUNT);
    }*/
