//受信くん用コントローラーシリアルライブラリ　by駒澤

#ifndef CTRL_SERIAL_H_
#define CTRL_SERIAL_H_

#include <mbed.h>
#include "ctrl_defines.h"
#include "gamma_defines.h"

class ctrl_serial
{
    public:
        
        ctrl_serial(int baudrate,int size);//(dps)
        
        unsigned char ctrl_data[256];
        
        enum Error_type
        {
            No_Error,
            Conect_Timeout,
            Receive_Failed,Receive_data_False,
            Buffer_Busy   
        };
        
         Error_type error_status;
    
    protected:
        static const unsigned char start_byte = 0xAA;
        int data_size;
        static const unsigned char stop_byte = 0x55;
        bool allready_set_data;
    private:
        Serial serial_dev;
        //Serial usb;
        int buffer_count;
        char buffer[256];
        unsigned char ctrl_raw_data[256];
        void ctrl_receive_data(void);
        void sending_data();
        
        Ticker timeout_checker;
        void timeout_check();
        bool timeout_call;
        static const double timeout_st_seconds = 0.5;
        
        //void data_checker();
        Error_type data_check();
        void data_table(Error_type error);
        bool checksum_read();
        
        void buffer_refresh();
        void buffer_shift();
        
        Timer time;
         
};

#endif