//受信くん用コントローラーシリアルライブラリ　by駒澤

#include "ctrl_serial.h"


ctrl_serial::ctrl_serial(int baudrate,int size)//(dps,byte)
    :serial_dev(CTRL_TX_PIN,CTRL_RX_PIN)//,usb(USBTX,USBRX)
{    
    //printf("super constructor\r\n");
    serial_dev.baud(baudrate);
    data_size = size;
    error_status = No_Error;
    allready_set_data = false;
    serial_dev.attach(this,&ctrl_serial::ctrl_receive_data,Serial::RxIrq);
    timeout_checker.attach(this,&ctrl_serial::timeout_check,timeout_st_seconds);
    timeout_call = false;
    time.start();
}


void ctrl_serial::ctrl_receive_data(void)
{
    if(serial_dev.readable())
    {
        timeout_call = true;
        buffer[buffer_count] = serial_dev.getc();
        //printf("%x ",buffer[buffer_count]);
        if(buffer_count + 1 >= data_size)
        {
            //printf("get_8b\r\n");
            data_table(data_check());
        }
        else
        {
            buffer_count++;
        }
    }     
}

ctrl_serial::Error_type ctrl_serial::data_check()
{
    if(buffer[0] == start_byte && buffer[buffer_count] == stop_byte)
    {
        //printf("data_get\r\n");
        if(checksum_read() == true){
            //printf("data_true\r\n");
            return No_Error;
        }
        else
        {
            //printf("data_false\r\n");
            return Receive_data_False;
        }
    }
    else
    {
        //printf("data_get_false\r\n");
        return Receive_Failed;
    }
}

void ctrl_serial::data_table(ctrl_serial::Error_type error){
    switch(error)
    {
        case No_Error:
            error_status = No_Error;
            buffer_count = 0;
            sending_data();
            allready_set_data = true;
            break;
            
        case Receive_Failed:
            error_status = Receive_Failed;
            buffer_shift();
            break;
            
        case Receive_data_False:
            error_status = Receive_data_False;
            buffer_shift();
            break;
            
        default:
            buffer_refresh();
            sending_data();
            break;
    }
            
}

void ctrl_serial::sending_data()
{
    for(int t = 0;t < data_size;t++)
        ctrl_data[t] = buffer[t];
}

bool ctrl_serial::checksum_read()
{
    unsigned int sum = 0;
    for(int t = 1;t < (data_size - 2);t++)
        sum = sum + buffer[t];
    unsigned char checksum = (unsigned char)(0xFF & sum);
    //printf("%x)",checksum);
    if(buffer[data_size - 2] == checksum)
    {
        return true;
    }
    else
    {
        return false;
    }   
}

void ctrl_serial::timeout_check()
{
    if(timeout_call == true)
    {
        timeout_call = false;
    }
    else
    {
        //printf("time_out\r\n");
        error_status = Conect_Timeout;
        buffer_refresh();
    }
}

void ctrl_serial::buffer_refresh()
{
    for(int t = 0;t < data_size;t++)
        buffer[t] = 0;
    sending_data(); 
    allready_set_data = true;
    buffer_count = 0;
}

void ctrl_serial::buffer_shift()
{
    for(int t = 0;t < data_size;t++)
        buffer[t] = buffer[t + 1];
       
}
    