#ifndef GAMMA_CTRL_H_
#define GAMMA_CTRL_H_

#include "ctrl_serial.h"

class gamma_ctrl : public ctrl_serial
{
    public:
        gamma_ctrl(int baudrate_g);
        void get_data();
        
        union gamma_packet
        {
            char all_data[GAMMA_DATA_SIZE];
            struct 
            {
                unsigned char start_byte:8;
                signed int rx :8;
                signed int ry :8;
                signed int lx :8;
                unsigned int r_sw1 :1;
                unsigned int r_sw2 :1;
                unsigned int r_sw3 :1;
                unsigned int r_sw4 :1;
                unsigned int r_s_sw1 :1;
                unsigned int r_s_sw2 :1;
                unsigned int l_sw1 :1;
                unsigned int l_sw2 :1;
                unsigned int l_sw3 :1;
                unsigned int l_sw4 :1;
                unsigned int l_s_sw1 :1;
                unsigned int l_s_sw2 :1;
                unsigned int mode1 :1;
                unsigned int mode2 :1;
                unsigned int r_srd :2;
                unsigned int l_srd :2;
                unsigned int no_data :6;
                unsigned char phecksum:8;
                unsigned char stop_byte :8;
            }data;
        };
        
        gamma_packet pack;

};

#endif