#include "ShooterAngle.h"

ShooterAngle::ShooterAngle(I2C *master, const unsigned int angle_max_, const unsigned int angle_min_):
    to_slave(alpha_a::angle, alpha_a::unsig, alpha_a::s3_addr, master),
    _angle_max(angle_max_),
    _angle_min(angle_min_)
{
    
}

void ShooterAngle::setAngle(unsigned int angle)
{
    uint8_t send_data = 0;
    if(_angle_max < angle)
        send_data = (uint8_t)_angle_max;
    else if(_angle_min > angle)
        send_data = (uint8_t)_angle_min;
    else
        send_data = (uint8_t)angle;
    printf("%d\r\n",send_data);    
    to_slave.write(send_data);
}