#ifndef MOTOR_DRIVER_TS120_H
#define MOTOR_DRIVER_TS120_H

#include "mbed.h"
#include "MotorDriver.h"

class TS120 : public MotorDriver
{
    public:
        TS120(PinName pwm_pin, bool _dir_flip = false, double _flont_range = 1, double _back_range = 1);
        virtual void drive(double _pwm);
        virtual void drive(signed int _pwm, unsigned int max_pwm_abs = 127);
    private:
        bool dir_flip;
        double flont_range;
        double back_range;
        PwmOut pwm_out;
        static const int pwm_max = 2000;
        static const int pwm_min = 1000;
};

#endif