#include "MD10c.h"

MD10c::MD10c(PinName dir_pin, PinName pwm_pin, bool _dir_flip)
:   dir_out(dir_pin), 
    pwm_out(pwm_pin)
{
    dir_flip = _dir_flip;
}

void MD10c::drive(double _pwm)
{
    bool dir = (dir_flip == false)?0 <= _pwm :0 >= _pwm;
    double pwm = fabs(_pwm);
    
    dir_out.write(dir);
    pwm_out.write(pwm);
    
}

void MD10c::drive(signed int _pwm, unsigned int max_pwm_abs)
{
    bool dir = (dir_flip == false)?0 <= _pwm :0 >= _pwm;
    double pwm = fabs((double)(max_pwm_abs / _pwm));
    
    dir_out.write(dir);
    pwm_out.write(pwm);
    
}