#include "TS120.h"

TS120::TS120(PinName pwm_pin, bool _dir_flip, double _flont_range, double _back_range)
:   pwm_out(pwm_pin)
{
    dir_flip = _dir_flip;
    flont_range = _flont_range;
    back_range = _back_range;
    
    drive(0);
    wait_ms(100);
}

void TS120::drive(double _pwm)
{
    double pwm = _pwm;
    
    if(dir_flip == true)
        pwm *= -1;
        
    if(_pwm > 0.0)
        pwm *= flont_range;
    else
        pwm *= back_range;
        
    int pwm_us = (int)((pwm_max - pwm_min) / 2) * (pwm + 1) + pwm_min; 
     
    pwm_out.pulsewidth_us(pwm_us);  
}

void TS120::drive(signed int _pwm, unsigned int max_pwm_abs)
{
    
    double pwm = (double)((1 / max_pwm_abs) * _pwm);
    
    if(dir_flip == true)
        pwm *= -1;
        
    if(pwm > 0.0)
        pwm *= flont_range;
    else
        pwm *= back_range;
        
    int pwm_us = (int)((pwm_max - pwm_min) / 2) * (pwm + 1) + pwm_min; 
      
    pwm_out.pulsewidth_us(pwm_us);
}