#include "GammaPool.h"

GammaPool::GammaPool()
{
    GammaPool::reset();
}

void GammaPool::up_load()
{
    data_index[0] = ctrl.rx;
    data_index[1] = ctrl.ry;
    data_index[2] = ctrl.lx;
    data_index[3] = ctrl.r_sw1;
    data_index[4] = ctrl.r_sw2;
    data_index[5] = ctrl.r_sw3;
    data_index[6] = ctrl.r_sw4;
    data_index[7] = ctrl.r_s_sw1;
    data_index[8] = ctrl.r_s_sw2;
    data_index[9] = ctrl.l_sw1;
    data_index[10] = ctrl.l_sw2;
    data_index[11] = ctrl.l_sw3;
    data_index[12] = ctrl.l_sw4;
    data_index[13] = ctrl.l_s_sw1;
    data_index[14] = ctrl.l_s_sw2;
    data_index[15] = ctrl.mode1;
    data_index[16] = ctrl.mode2;
    data_index[17] = ctrl.r_srd;
    data_index[18] = ctrl.l_srd;
    data_index[19] = ar.r.max_limit;
    data_index[20] = ar.r.min_limit;
    data_index[21] = ar.l.max_limit;
    data_index[22] = ar.l.min_limit;
    a.r.pwm = data_index[23];
    a.r.fire1 = data_index[24];
    a.r.fire2 = data_index[25];
    a.l.pwm = data_index[26];
    a.l.fire1 = data_index[27];
    a.l.fire2 = data_index[28];
    a.k.pwm = data_index[29];
    a.k.fire = data_index[30];          
    a.sao_call1 = data_index[31];
    a.sao_call2 = data_index[32];        
}
        
void GammaPool::reset(){
    for(int t = 0; t < 10; t++)
        ctrl.all_data[t] = 0;
    for(int t = 0; t < 4; t++)
        a.all_data[t] = 0;
    ar.all_data[0] = 0;
}