#include "CtrlMD.h"

CtrlMD::CtrlMD(MotorDriver *_MD, double _inval, double _err)
:    inval(_inval), err(_err), current_pwm(0.0)
{
    MD = _MD;
    driving_interval.attach(this, &CtrlMD::driving, inval);
}

void CtrlMD::reform_inval(double _inval)
{
    inval = _inval;
}

void CtrlMD::drive(double _pwm)
{
    target_pwm = _pwm;
    //printf("%f,",current_pwm);
}



void CtrlMD::driving(){
    if(fabs(target_pwm - current_pwm) > err){
        if(target_pwm < current_pwm){
            current_pwm -= err;
        } else {
            current_pwm += err;
        }
    }
    MD->drive(current_pwm);
    driving_interval.attach(this, &CtrlMD::driving, inval);
}