#include "BoolProcess.h"

BoolProcess::BoolProcess()
:   wait_count()
{
    stamp_count = false;
}

bool BoolProcess::push(int _in_val, unsigned int wait_time_ms)
{
    in_val = (bool)_in_val;
    if(wait_time_ms == 0)
        out_val = in_val;
    else
        wait_count.start();
        
    if(in_val == 1)
    {
        if(wait_count.read_ms() >= wait_time_ms)
        {
            out_val = 1;
        }
        else
            out_val = 0;
    }
    else
    {
        out_val = 0;
        wait_count.reset();
    }
    
    return out_val;
}

bool BoolProcess::stamp(int _in_val)
{
    in_val = (bool)_in_val;
    if(in_val == true && stamp_count == false)
    {
        out_val = true != out_val;
        stamp_count = true;
    }
    else if(in_val == false && stamp_count == true)
        stamp_count = false;
        
    return out_val;
}

void BoolProcess::stamp_reset()
{
    out_val = 0;
}
