#include "BetaTransporter.h"

BetaTransporter::BetaTransporter()
:   pool(),
    i2c(SDA,SCL)
{
    
}

bool BetaTransporter::set()
{
    bool no_error = true;
    
    i2c.transport_begin(JUSHINKUN_ADDR, pool.ctrl.all_data, 10);
    no_error = no_error & i2c.read();
    i2c.transport_end();
    
    /*i2c.transport_begin(APPER_BODY_ADDR, pool.a.all_data, 4);
    no_error = no_error & i2c.write();
    i2c.transport_end();
    
    i2c.transport_begin(APPER_BODY_ADDR, pool.ar.all_data, 1);
    no_error = no_error & i2c.read();
    i2c.transport_end();
    */
    
    pool.up_load();
    
    return no_error;
}

void BetaTransporter::write(int index_num, int data)
{
    pool.data_index[index_num] = data;
}


int BetaTransporter::read(int index_num)
{
    return pool.data_index[index_num];
}

void BetaTransporter::reset()
{
    pool.reset();
}
    