#include "ApprI2CSlave.h"

ApprI2CSlave::ApprI2CSlave(alpha_a::ID my_id_, alpha_a::f_type my_type_, int addr_, I2CSlave *slave_)
{
    _my_id = my_id_;
    _my_type = my_type_;
    _slave = slave_;
    _slave->address(addr_);
    res_data = 0;
}

void ApprI2CSlave::write(uint8_t data)
{
    char data_array[3] = {};
    
    data_array[0] = _my_id;
    data_array[1] = _my_type;
    data_array[2] = (char)data;
    if(I2CSlave::ReadAddressed == _slave->receive())
        _slave->write(data_array, 3);
}

int ApprI2CSlave::read()
{
    char buffer[3] = {};
    if(I2CSlave::WriteAddressed == _slave->receive())
    {
        //printf("receive_now\r\n");
        _slave->read(buffer, 3);
        if((alpha_a::ID)buffer[0] == _my_id)
        {
            switch((alpha_a::f_type)buffer[1])
            {
                case alpha_a::sig:
                    res_data = (signed int)buffer[2];
                    break;
                case alpha_a::unsig:
                    res_data = (unsigned int)buffer[2];
                    break;
            };
        
        }
    }
    

    
    return res_data;
}