#include "ApprI2CMaster.h"

ApprI2CMaster::ApprI2CMaster(alpha_a::ID my_id_, alpha_a::f_type my_type_, int addr_, I2C *master_)
{
    _my_id = my_id_;
    _my_type = my_type_;
    _master = master_;
    _addr = addr_;
    res_data = 0;
}

void ApprI2CMaster::write(uint8_t data)
{
    char data_array[3] = {};
    
    data_array[0] = _my_id;
    data_array[1] = _my_type;
    data_array[2] = (char)data;
    
    _master->write(_addr, data_array, 3);
}

int ApprI2CMaster::read()
{
    char buffer[3] = {};
    
    _master->read(_addr, buffer, 3);
    
    if((alpha_a::ID)buffer[0] == _my_id)
    {
        switch((alpha_a::f_type)buffer[1])
        {
            case alpha_a::sig:
                res_data = (signed int)buffer[2];
                break;
            case alpha_a::unsig:
                res_data = (unsigned int)buffer[2];
                break;
        };
        
    }
    
    return res_data;
}